/*
 *  Description: Camera Data Sampling
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : syncdet4b
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/




module syncdet4b (
                  vp_clk, 
                  rstxxa_n,         //Asynchronous
                  vi,               //Asynchronous
                  enph,             //clocked by vp_clk
                  runframelock,     //clocked by vp_clk
                  phdata,           //clocked by vp_clk
                  ok0,              //clocked by vp_clk
                  ok1               //clocked by vp_clk
                 );

input        vp_clk, 
             rstxxa_n;
input  [3:0] vi; 
input        enph, 
             runframelock; 

output [3:0] phdata,
             ok0, 
             ok1;

reg    [3:0] ok0, 
             ok1, 
             phdata, 
             phdata2, 
             phdata4; 
 
   always @ (posedge vp_clk or negedge rstxxa_n) 
      begin
         if (!rstxxa_n) 
            begin
               ok0     <= 4'b1111;
               phdata  <= 4'b1111;
               phdata2 <= 4'b0000;
            end
         else
            if (enph)
               if (!runframelock)
                  begin
                     ok0     <= 4'b1111;
                     phdata  <= vi;
                     phdata2 <= 4'b0000;
                  end
               else
                  begin
                     ok0[0]  <= (ok0[0] & (phdata[0] ^ phdata2[0]));
                     ok0[1]  <= (ok0[1] & (phdata[1] ^ phdata2[1]));
                     ok0[2]  <= (ok0[2] & (phdata[2] ^ phdata2[2]));
                     ok0[3]  <= (ok0[3] & (phdata[3] ^ phdata2[3]));
                     phdata <= vi;
                     phdata2 <= phdata;
                  end
            else
               begin
                  ok0     <= ok0;
                  phdata  <= phdata;
                  phdata2 <= phdata2;
               end
      end



   always @ (posedge vp_clk or negedge rstxxa_n) 
      begin
         if (!rstxxa_n) 
            begin
               ok1     <= 4'b1111;
               phdata4 <= 4'b1111;
            end
         else
            if (enph)
               if (!runframelock)
                  begin
                     ok1     <= 4'b1111;
                     phdata4 <= 4'b1111;
                  end
               else
                  begin
                     ok1[0]  <= (ok1[0] & (phdata[0] ^ phdata4[0]));
                     ok1[1]  <= (ok1[1] & (phdata[1] ^ phdata4[1]));
                     ok1[2]  <= (ok1[2] & (phdata[2] ^ phdata4[2]));
                     ok1[3]  <= (ok1[3] & (phdata[3] ^ phdata4[3]));
                     phdata4 <= phdata;
                  end
            else
               begin
                  ok1     <= ok1;
                  phdata4 <= phdata4;
               end
      end

endmodule
