/*
 *  Description: Sample Enable Generator.
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : syncctrl
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

module syncctrl (
                 vp_clk, 
                 vp_clk_n, 
                 rstxxa_n,         //Asynchronous
                 hotphasein,       //clocked by clk14
                 override,         //clocked by clk14
                 runframelock,     //clocked by vp_clk 
                 ok0_ph1,          //clocked by vp_clk_n 
                 ok0_ph3,          //clocked by vp_clk_n 
                 ok1_ph1,          //clocked by vp_clk_n
                 ok1_ph3,          //clocked by vp_clk_n
                 sync_hotphasein,  //clocked by vp_clk
                 sync_override,    //clocked by vp_clk
                 p_runframelock,   //clocked by vp_clk 
                 n_runframelock,   //clocked by vp_clk_n 
                 end_of_lock,      //combin from vp_clk 
                 sync_ok0_ph1,     //clocked by vp_clk 
                 sync_ok0_ph3,     //clocked by vp_clk 
                 sync_ok1_ph1,     //clocked by vp_clk
                 sync_ok1_ph3      //clocked by vp_clk
                );

input        vp_clk, 
             vp_clk_n,
             rstxxa_n;
input  [1:0] hotphasein;
input        override,
             runframelock;
input  [3:0] ok0_ph1, 
             ok0_ph3, 
             ok1_ph1, 
             ok1_ph3; 

output [1:0] sync_hotphasein;
output       sync_override,
             p_runframelock, 
             end_of_lock, 
             n_runframelock; 

output [3:0] sync_ok0_ph1, 
             sync_ok0_ph3, 
             sync_ok1_ph1, 
             sync_ok1_ph3; 

reg          p_runframelock, 
             p_rfl_del, 
             n_runframelock; 

wire         end_of_lock;

reg    [3:0] sync_ok0_ph1, 
             sync_ok0_ph3, 
             sync_ok1_ph1, 
             sync_ok1_ph3; 

reg    [1:0] sync_hotphasein;
reg          sync_override;

reg    [1:0] int_hotphasein;
reg          int_override;


assign end_of_lock = (~p_runframelock) & p_rfl_del;


   always @(posedge vp_clk_n or negedge rstxxa_n) 
      begin
         if (!rstxxa_n)
            begin
               n_runframelock <= 1'b0;
               int_hotphasein <= 2'b00;
               int_override   <= 1'b0;
            end
         else 
            begin
               n_runframelock <= runframelock;
               int_hotphasein <= hotphasein;
               int_override   <= override;
            end
      end

   always @(posedge vp_clk or negedge rstxxa_n) 
      begin
         if (!rstxxa_n)
            begin
               p_runframelock  <= 1'b0;
               p_rfl_del       <= 1'b0;
               sync_ok0_ph1    <= 4'b0000;
               sync_ok0_ph3    <= 4'b0000; 
               sync_ok1_ph1    <= 4'b0000; 
               sync_ok1_ph3    <= 4'b0000; 
               sync_hotphasein <= 2'b00;
               sync_override   <= 1'b0;
            end
         else 
            begin
               p_runframelock  <= runframelock;
               p_rfl_del       <= p_runframelock;
               sync_ok0_ph1    <= ok0_ph1;
               sync_ok0_ph3    <= ok0_ph3; 
               sync_ok1_ph1    <= ok1_ph1; 
               sync_ok1_ph3    <= ok1_ph3; 
               sync_hotphasein <= int_hotphasein;
               sync_override   <= int_override;
            end
      end



endmodule
