/*
 *  Description: Sample Phase gen.
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : phasegen
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



module phasegen (
                 vp_clk, 
                 vp_clk_n, 
                 rstxxa_n, 
                 enph0,           //clocked by vp_clk
                 enph1,           //clocked by vp_clk_n
                 enph2,           //clocked by vp_clk
                 enph3            //clocked by vp_clk_n
                );

input        vp_clk, 
             vp_clk_n,
             rstxxa_n;
output       enph0, 
             enph1, 
             enph2, 
             enph3;

reg          enph0, 
             enph1, 
             enph2, 
             enph3;



  always @ (posedge vp_clk or negedge rstxxa_n) 
     begin
        if (!rstxxa_n)
           begin
              enph0 <= 0;
              enph2 <= 0;
           end
        else 
           begin
              enph0 <= ~enph0;
              enph2 <= enph0;
           end
     end

  always @ (posedge vp_clk_n or negedge rstxxa_n) 
     begin
        if (!rstxxa_n)
           begin
              enph1 <= 0;
              enph3 <= 0;
           end
        else 
           begin
              enph1 <= enph0;
              enph3 <= enph1;
           end
     end


endmodule
