/*
 *  Description: Gain and Offset on Video Stream
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : gain_offs
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

module gain_offs (in, resetb, vp_clk, pclkd2, barsrq, evenfirst, lefthalfd1, intqcif, ienv,
			hjog, rflag, baraddr, offset, rcomp, g1comp, g2comp, bcomp, out);
	parameter DBITS8 = 9;
	parameter CBITS8 = 8;
	parameter OBITS8 = 11;
	parameter RBITPOSN8 = (DBITS8+CBITS8) - (OBITS8+1);

	input [7:0] in, offset;
	input [8:0] baraddr;
	input [CBITS8-1:0] rcomp, g1comp, g2comp, bcomp;
	input resetb, vp_clk, pclkd2, barsrq, intqcif, evenfirst, lefthalfd1, ienv, hjog, rflag;
	output [7:0] out;
	reg [7:0] out, hotcof, finalenvdel;
	wire [11:0] oneplusprod;
	wire [10:0] offint, prod;
	wire [9:0] offout;
	wire [8:0] offcliplo, hotdat;
	wire [7:0] barval, finalval, tppcliphi, finalenv;
	wire [3:0] barzone;
	wire lefthalfdash;
	reg barcode;

// hjog
	assign lefthalfdash = hjog ? !lefthalfd1 : lefthalfd1;

// subtract offset
	assign offint = {2'd0,in,1'd1} + {~offset[7],~offset[7],~offset,1'd1};
	assign offout = offint[10:1];

// clip negative numbers to zero
	function [8:0] loclip;
		input[9:0] in;
		case(in[9])
			0:      loclip = in[8:0];
			1:      loclip = 9'b0;
		endcase
	endfunction

	assign offcliplo = loclip(offout);

// select Bayer channel coefficient, or generate bar zone, after barsrq
// truncating multiply by 93 replaces truncating divide by 44 on baraddr, giving bar zone
	always @ (barsrq or evenfirst or rflag or lefthalfdash
				or rcomp or g1comp or g2comp or bcomp) begin
		case({barsrq,evenfirst,rflag,lefthalfdash})
			0:	hotcof = bcomp;
			1:	hotcof = g2comp;
			2:	hotcof = g1comp;
			3:	hotcof = rcomp;
			4:	hotcof = g2comp;
			5:	hotcof = bcomp;
			6:	hotcof = rcomp;
			7:	hotcof = g1comp;
			default:	hotcof = 93;
		endcase
	end
	
// truncating multiply
	function [OBITS8-1:0] tm090811;
		input [DBITS8-1:0] dat;
		input [CBITS8-1:0] cof;
		reg [DBITS8+CBITS8-1:0] fullprod;
		reg [DBITS8:0] hiprod;
		reg [CBITS8-1:0] loprod;
		reg [CBITS8-3:0] lotmp;
		reg [CBITS8:0] mbcof;
		reg [DBITS8:0] pp, pp1;
		reg [DBITS8:0] ppsds2;
		reg [DBITS8+3:0] pps;

		integer i;

		begin
			mbcof = {cof,1'b0};
			ppsds2 = 0;
			lotmp = 0;
			for(i=2; i<=CBITS8; i = i + 2) begin
				case(mbcof[2:0])
					0:      pp1 = 0;
					1:      pp1 = {1'b0,dat};
					2:      pp1 = {1'b0,dat};
					3:      pp1 = {dat,1'b0};
					4:      pp1 = {dat,1'b0};
					5:      pp1 = {1'b0,dat};
					6:      pp1 = {1'b0,dat};
					7:      pp1 = 0;
				endcase
				case(mbcof[2])
					0:      pp = pp1;
					1:      pp = ~pp1;
				endcase
				pps = {ppsds2[DBITS8],ppsds2[DBITS8],ppsds2,mbcof[2]}
					+ {mbcof[2],mbcof[2],pp,mbcof[2]};
				ppsds2 = {pps[DBITS8+3:3]};
				loprod = {pps[2:1],lotmp};
				mbcof = mbcof >> 2;
				lotmp = loprod >> 2;
			end
			hiprod = pps[DBITS8+3:3];
			fullprod = {hiprod,loprod};
			tm090811 = fullprod[DBITS8+CBITS8-1:DBITS8+CBITS8-OBITS8];
		end

	endfunction

// multiplier data select after barsrq
	assign hotdat = barsrq ? baraddr : offcliplo;
	assign prod = tm090811(hotdat,hotcof);
// data output is 2*(1 + c) * x, insert rounding bit here
// small compromise between perfect rounding and perfect bar transitions
	assign oneplusprod = {1'b0,offcliplo,2'd1} + {prod,1'b1};

// window 1-bit up and clip large positive numbers to 8-bit
	function [7:0] hiclip;
		input[11:0] in;
		case(in[9] | in[10] | in[11])
			0:      hiclip = in[8:1];
			1:      hiclip = 8'd255;
		endcase
	endfunction
	assign tppcliphi = hiclip(oneplusprod);

// barcode and barval from zone and Bayer context
// barvals are nearest 8-bit integers to antigamma'd NTSC bars
// untidy clip required to hold last state, as we use 352 to approximate 356

// !FRIG FOR SHORT LINE!!!
	assign barzone = prod[9] ? 7 : prod[8:6];
//	assign barzone = prod[6] ? 7 : prod[5:3];
	always @ (barzone or evenfirst or rflag or lefthalfdash) begin
		case({evenfirst,rflag,lefthalfdash})
			0:	barcode = barzone[0];
			1:	barcode = barzone[2];
			2:	barcode = barzone[2];
			3:	barcode = barzone[1];
			4:	barcode = barzone[2];
			5:	barcode = barzone[0];
			6:	barcode = barzone[1];
			7:	barcode = barzone[2];
		endcase
	end
	assign barval = barcode ? 1 : 143;

// select bars or data
	assign finalval = barsrq ? barval : tppcliphi;
	assign finalenv = ienv ? finalval : 0;

// clock out (inc late red for QCIF addressing)
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			out <= 0;
			finalenvdel <= 0;
		end else begin
			out <= pclkd2 ? ((intqcif & rflag & lefthalfd1) ? finalenvdel : finalenv) : out;
			finalenvdel <= pclkd2 ? finalenv : finalenvdel;
		end
	end

endmodule
