/*
 *  Description: Camera Data Phase Detector (top).
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : allph_syncdet
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/




module allph_syncdet (
                      vp_clk, 
                      vp_clk_n, 
                      rstxxa_n,         //Asynchronous
                      rx_sftrst_n,      //Asynchronous
                      vi,               //Asynchronous
                      runframelock,     //clocked by vp_clk
                      hotphasein,       //clocked by clk14
                      override,         //clocked by clk14
                      enph0,            //clocked by vp_clk
                      enph2,            //clocked by vp_clk
                      gooddata,         //clocked by vp_clk
                      fail,             //clocked by vp_clk
                      hotphaseout       //clocked by vp_clk
                     );

input        vp_clk, 
             vp_clk_n, 
             rstxxa_n,
             rx_sftrst_n;
input  [3:0] vi; 
input        runframelock; 
input  [1:0] hotphasein;
input        override;

output       enph0;
output       enph2;
output [3:0] gooddata;
output       fail;
output [1:0] hotphaseout;

wire   [1:0] sync_hotphasein;
wire         sync_override;

wire   [3:0] ok0_ph0, 
             ok0_ph1, 
             ok0_ph2, 
             ok0_ph3, 
             ok1_ph0, 
             ok1_ph1, 
             ok1_ph2, 
             ok1_ph3, 
             ph0data, 
             ph1data, 
             ph2data, 
             ph3data; 

wire   [3:0] sync_ok0_ph1, 
             sync_ok0_ph3, 
             sync_ok1_ph1, 
             sync_ok1_ph3; 
 
phasegen    phgen (
                   .vp_clk(vp_clk), 
                   .vp_clk_n(vp_clk_n), 
                   .rstxxa_n(rstxxa_n), 
                   .enph0(enph0),                     //clocked by vp_clk
                   .enph1(enph1),                     //clocked by vp_clk_n
                   .enph2(enph2),                     //clocked by vp_clk
                   .enph3(enph3)                      //clocked by vp_clk_n
                  );

syncctrl  ctrl    (
                   .vp_clk(vp_clk), 
                   .vp_clk_n(vp_clk_n), 
                   .rstxxa_n(rstxxa_n),               //Asynchronous
                   .hotphasein(hotphasein),           //clocked by clk14
                   .override(override),               //clocked by clk14
                   .runframelock(runframelock),       //clocked by vp_clk 
                   .ok0_ph1(ok0_ph1),                 //clocked by vp_clk_n 
                   .ok0_ph3(ok0_ph3),                 //clocked by vp_clk_n 
                   .ok1_ph1(ok1_ph1),                 //clocked by vp_clk_n
                   .ok1_ph3(ok1_ph3),                 //clocked by vp_clk_n
                   .sync_hotphasein(sync_hotphasein), //clocked by vp_clk
                   .sync_override(sync_override),     //clocked by vp_clk
                   .p_runframelock(p_runframelock),   //clocked by vp_clk 
                   .n_runframelock(n_runframelock),   //clocked by vp_clk_n 
                   .end_of_lock(end_of_lock),         //combin from vp_clk 
                   .sync_ok0_ph1(sync_ok0_ph1),       //clocked by vp_clk 
                   .sync_ok0_ph3(sync_ok0_ph3),       //clocked by vp_clk 
                   .sync_ok1_ph1(sync_ok1_ph1),       //clocked by vp_clk
                   .sync_ok1_ph3(sync_ok1_ph3)        //clocked by vp_clk
                  );

syncdet4b syncph0 (
                   .vp_clk(vp_clk), 
                   .rstxxa_n(rstxxa_n),               //Asynchronous
                   .vi(vi),                           //Asynchronous
                   .enph(enph0),                      //clocked by vp_clk
                   .runframelock(p_runframelock),     //clocked by vp_clk
                   .phdata(ph0data),                  //clocked by vp_clk
                   .ok0(ok0_ph0),                     //clocked by vp_clk
                   .ok1(ok1_ph0)                      //clocked by vp_clk
                  );

syncdet4b syncph1 (
                   .vp_clk(vp_clk_n), 
                   .rstxxa_n(rstxxa_n),               //Asynchronous
                   .vi(vi),                           //Asynchronous
                   .enph(enph1),                      //clocked by vp_clk_n
                   .runframelock(n_runframelock),     //clocked by vp_clk_n
                   .phdata(ph1data),                  //clocked by vp_clk_n
                   .ok0(ok0_ph1),                     //clocked by vp_clk_n
                   .ok1(ok1_ph1)                      //clocked by vp_clk_n
                  );

syncdet4b syncph2 (
                   .vp_clk(vp_clk), 
                   .rstxxa_n(rstxxa_n),               //Asynchronous
                   .vi(vi),                           //Asynchronous
                   .enph(enph2),                      //clocked by vp_clk
                   .runframelock(p_runframelock),     //clocked by vp_clk
                   .phdata(ph2data),                  //clocked by vp_clk
                   .ok0(ok0_ph2),                     //clocked by vp_clk 
                   .ok1(ok1_ph2)                      //clocked by vp_clk
                  );

syncdet4b syncph3 (
                   .vp_clk(vp_clk_n), 
                   .rstxxa_n(rstxxa_n),               //Asynchronous
                   .vi(vi),                           //Asynchronous
                   .enph(enph3),                      //clocked by vp_clk_n
                   .runframelock(n_runframelock),     //clocked by vp_clk_n
                   .phdata(ph3data),                  //clocked by vp_clk_n
                   .ok0(ok0_ph3),                     //clocked by vp_clk_n
                   .ok1(ok1_ph3)                      //clocked by vp_clk_n
                  );

phasesel    phsel (
                   .vp_clk(vp_clk),
                   .rstxxa_n(rstxxa_n),               //Asynchronous
                   .rx_sftrst_n(rx_sftrst_n),         //Asynchronous
                   .enph0(enph0),                     //clocked by vp_clk
                   .sync_hotphasein(sync_hotphasein), //clocked by vp_clk
                   .sync_override(sync_override),     //clocked by vp_clk
                   .end_of_lock(end_of_lock),         //combin from vp_clk
                   .ph0data(ph0data),                 //clocked by vp_clk
                   .ph1data(ph1data),                 //clocked by vp_clk_n
                   .ph2data(ph2data),                 //clocked by vp_clk
                   .ph3data(ph3data),                 //clocked by vp_clk_n
                   .ok0_ph0(ok0_ph0),                 //clocked by vp_clk 
                   .sync_ok0_ph1(sync_ok0_ph1),       //clocked by vp_clk 
                   .ok0_ph2(ok0_ph2),                 //clocked by vp_clk 
                   .sync_ok0_ph3(sync_ok0_ph3),       //clocked by vp_clk 
                   .ok1_ph0(ok1_ph0),                 //clocked by vp_clk
                   .sync_ok1_ph1(sync_ok1_ph1),       //clocked by vp_clk
                   .ok1_ph2(ok1_ph2),                 //clocked by vp_clk
                   .sync_ok1_ph3(sync_ok1_ph3),       //clocked by vp_clk
                   .gooddata(gooddata),               //clocked by vp_clk
                   .fail(fail),                       //clocked by vp_clk
                   .hotphaseout(hotphaseout)          //clocked by vp_clk
                  );

endmodule
