/*
 *  Description: VPE Control and Line RAM Address Generator
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : addrgen
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 22-MAY-97:  Bring up VVL652 modifications
 * 05-JUN-97:  Purge henv
 * 05-JUN-97:  Bring up VVL653 modifications, new flenv, llenv sigs out
 * 10-JUN-97:  Re-time framegrab signals to pclkd4
 * 11-JUN-97:  Advance flenv by 1 line in CIF, 2 lines in QCIF
 * 12-JUN-97:  Restore blocking assignments for oimmnt etc.
 * 12-JUN-97:  WEBs, CEBs, rsflag made synchronous
 * 12-JUN-97:  Flenv vert decode fix
 * 13-JUN-97:  Default intqcif changed to 0 (CIF mode)
 * 19-JUN-97:  Reset state added for rceb0
*/

/**************************************************
Externally driven address generator.
Needs to be self-started too
**************************************************/
// !FRIG for shorts
`define IHSIZE  9'd356
`define IHSIZED2 9'd178
`define PIXLIM30 9'd393
`define PIXLIM25 9'd471
`define SAFEVAL  9'd384
`define IVSIZE  9'd292
`define IVSTART  9'd10
`define LINLIM  9'd304
/*
*/
/*
`define IHSIZE  9'd44
`define IHSIZED2 9'd22
`define PIXLIM30 9'd59
`define PIXLIM25 9'd67
`define SAFEVAL  9'd52
`define IVSIZE  9'd36
`define IVSTART  9'd4
`define LINLIM  9'd42
*/
module addrgen (
                resetb, 
                vp_clk, 
                rx_VP_PCLK, 
                zoom, 
                qcif, 
                hz30, 
                auto, 
                evenfirst, 
                hjog, 
                vjog,
		stndrd,
		vsolid,
		skip, 
                sof, 
                rxlcnt, 
                rx_DATA_IMMINENT,
		addr0, 
                addr1, 
                baraddr, 
		ceb0, 
                ceb1, 
                ceb2, 
                ceb3, 
                web0, 
                web1, 
                web2, 
                web3,
		rcatch0_posen, 
                rcatch1_posen, 
		rcatch2_posen, 
                rcatch3_posen, 
		ienv, 
                qlinekill,
		menv, 
                oenv, 
                ramadd, 
                rsflag, 
                gseflag, 
                vlenv,
		pclkd1, 
		pclkd2, 
                pclkd4, 
                rflag, 
                lefthalf, 
                lefthalfd1,
		f_int, 
                fst, 
                lst,
		flenv, 
		llenv, 
		olcnt, 
                intzoom, 
                intqcif, 
                intskip
               );

input        resetb, 
             vp_clk, 
             rx_VP_PCLK, 
             zoom, 
             qcif, 
             hz30, 
             auto, 
             evenfirst, 
             hjog, 
             vjog, 
             rx_DATA_IMMINENT;
input        stndrd, 
             vsolid;
input        skip, 
             sof;
input  [8:0] rxlcnt;
output [8:0] olcnt, 
             addr0, 
             addr1, 
             baraddr;
output       ceb0, 
             ceb1, 
             ceb2, 
             ceb3, 
             web0,  
             web1, 
             web2, 
             web3, 
             pclkd1, 
             pclkd2, 
             pclkd4, 
             rflag;
output       ienv, 
             qlinekill, 
             lefthalf, 
             lefthalfd1;
output       rcatch0_posen, 
             rcatch1_posen, 
             rcatch2_posen, 
             rcatch3_posen;
output       menv, 
             oenv, 
             ramadd, 
             rsflag, 
             gseflag, 
             vlenv, 
             intzoom, 
             intqcif, 
             intskip;
output       f_int, 
             fst, 
             lst,
             flenv,
             llenv;

wire   [8:0] raddr0, 
             waddr0, 
             addr0, 
             addr1, 
             baraddr;
wire   [8:0] waddr0cearly, 
             waddr0q;
reg          rcatch0, 
             rcatch1, 
             rcatch2, 
             rcatch3;
wire         rcatch0_posen, 
             rcatch1_posen, 
             rcatch2_posen, 
             rcatch3_posen;
wire         ramadd, 
             gseflagearly;
reg          rsflag; 
reg    [8:0] waddr0c, 
             raddr0c, 
             ipcnt, 
             aulcnt, 
             olcnt;
reg          lefthalf;
reg          lefthalf_int, 
             gseflag;
wire   [8:0] pixlim, 
             ilcnt;
reg    [7:0] waddrbits;
wire         qlinekill, 
             rx_VP_PCLK, 
             rflag;
reg          wceb1c, 
             rceb1c, 
             wceb2c, 
             rceb2c, 
             wceb3c, 
             rceb3c; 
reg          wceb1q, 
             wceb2q, 
             wceb3q; 
wire         ceb0; 
reg          wceb0, 
             rceb0, 
             wceb1, 
             rceb1, 
             ceb1, 
             wceb2, 
             rceb2, 
             ceb2, 
             wceb3, 
             rceb3, 
             ceb3; 
reg          web1c, 
             web2c, 
             web3c, 
             web1q, 
             web2q, 
             web3q;
reg          ivenv, 
             rvenv0, 
             rvenv1, 
             rvenv2, 
             rvenv3, 
             rvenv4, 
             dvalidenv, 
             dvalidenv_int, 
             dimmntenv;
wire         menv, 
             oenv, 
             ienv, 
             waddrlsb;
reg          pclkd1, 
             pclkd2, 
             pclkd3, 
             pclkd4;
reg          dvalidenvd2, 
             dvalidenvd1, 
//             lefthalfd2, 
             lefthalfd1;
reg          lefthalfd2_int, 
             lefthalfd1_int;
wire         isof, 
             dimmntsynth;
reg          rsgseenv;
wire [8:0]   ctest656, 
             qtest656;

reg          oimmnt;
reg          mdvalidenv, 
             mdvalidenvdel, 
             mdvalidenvd2;
reg          ivenvd2, 
             intzoom, 
             inthz30, 
             intqcif, 
             intskip, 
             odvalidenvdel, 
             odvalidenv, 
             qwinhenv;
reg          f_int, 
             fst, 
             lst,
             flenv,
             llenv;
// wire         henv;

// regs needed for vp_clk synchronisation:
reg          sof_edge,isof_edge,dimmntsynth_edge,oimmnt_edge;

// regs needed for web & ceb registering:
reg          ivenv_int,web0,web1,web2,web3;
//reg          ceb1,ceb2,ceb3;
reg          rvenv0_int, rvenv1_int, rvenv2_int, rvenv3_int;
reg [8:0]    olcnt_int;



// re-issue self-clearing skip timed to start of output frame envelope
// *** Modified for synchronization ***
// sof => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  intskip <= 0;
                  sof_edge <= 0;
		end
                else
                begin
                  if ((!sof_edge) & (sof))
                  begin
                    intskip <= skip;
                  end
                  sof_edge <= sof;
		end
	end

// re-issue self-clearing hz30, zoom & qcif timed to start of input frame envelope
// note zoom only enabled in QCIF mode


// *** Modified for synchronization ***
// vp_clk_n => vp_clk

// pclkd2n_posen => pclkd2

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb)
			ivenvd2 <= 0;
		else
                   begin
                      if (pclkd2)
                         ivenvd2 <= ivenv;
                      else
                         ivenvd2 <= ivenvd2;
                   end
	end
	assign isof = ivenv & !ivenvd2;

// *** Modified for synchronization ***
// isof => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  inthz30 <= 1;
                  intzoom <= 0;
                  intqcif <= 0;
                  isof_edge <= 0;
		end
                else
                begin
                  if ((!isof_edge) & (isof))
                  begin
                    inthz30 <= hz30;
                    intzoom <= qcif ? zoom : 0;
                    intqcif <= zoom ? 0 : qcif;
                  end
                  isof_edge <= isof;
		end
	end


// *** Modified for synchronization ***
// rx_VP_PCLK => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
		  dimmntenv <= 0;
		end
                else
                begin
                  if (rx_VP_PCLK)
                  begin
                    if(((ipcnt + 1) & 511) >= pixlim)
                    begin
                      dimmntenv <= 1;
                    end
                    else
                    begin
                      dimmntenv <= 0;
                    end
                  end
		end
	end

	assign dimmntsynth = auto ? dimmntenv & pclkd1 : rx_DATA_IMMINENT & rx_VP_PCLK;

// counter for line count, vertical envelopes
// tactical: rx linecount is too late for our needs here
// anticipate by (compile-time) decrementing event triggers and comparing with olcnt
// *** Modified for synchronization ***
// dimmntsynth => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
                  aulcnt <= 511;
                  ivenv <= 0;
                  ivenv_int = 0;
                  dimmntsynth_edge <= 0;
                  web0 <= 1;
                  wceb0 <= 1;
		end else begin
                  if ((!dimmntsynth_edge) & (dimmntsynth)) begin
                    if((olcnt + 1) >= (`LINLIM - 1))
                    begin
                      aulcnt <= 0;
                      ivenv <= 0;
                      ivenv_int = 0;
                    end
                    else if((olcnt + 1) < (`IVSTART - 1))
                    begin
                      aulcnt <= (olcnt + 1);
                      ivenv <= 0;
                      ivenv_int = 0;
                    end
                    else if((olcnt + 1) < (`IVSTART + `IVSIZE - 1))
                    begin
                      aulcnt <= (olcnt + 1);
                      ivenv <= 1;
                      ivenv_int = 1;
                    end
                    else
                    begin
                      aulcnt <= (olcnt + 1);
                      ivenv <= 0;
                      ivenv_int = 0;
                    end
                  end
                  dimmntsynth_edge <= dimmntsynth;
                  // Logic to generate WEB & CEB out of FF's
                  if (rx_VP_PCLK | pclkd1)
                    web0 <= !(dvalidenvd2 & ivenv_int);
                  else
                    web0 <= 1;
                  wceb0 <= !(pclkd1 & dvalidenvd2 & ivenv_int);
				end
	end
	assign ilcnt = auto ? aulcnt : rxlcnt;

// select auto or receiver-generated controls
	assign rflag = (vjog ? ilcnt[0] : !ilcnt[0]);

// delay controls past defcor to inproc bargen and addrgen
// *** Modified for synchronization ***
// rx_VP_PCLK => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  dvalidenvd1 <= 0;
		end
                else
                begin
                  if (rx_VP_PCLK) dvalidenvd1 <= dvalidenv;
		end
	end


// *** Modified for synchronization ***
// dimresetb not necessary because = synchronous reset.
//	assign dimresetb = resetb & !dimmntsynth;

// *** Modified for synchronization ***
// rx_VP_PCLK => vp_clk
// This block included in different always block!
/*
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lefthalfd2 <= 0;
                  lefthalfd1 <= 0;
		end
                else
                begin
                  if (rx_VP_PCLK)
                  begin
                    lefthalfd2 <= lefthalfd1;
                    lefthalfd1 <= lefthalf;
                  end
		end
	end
*/

// special case for glitch-free web envelope
// *** Modified for synchronization ***
// vp_clk_n => vp_clk

// pclkd3n_posen => pclkd3

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			dvalidenvd2 <= 0;
		end else begin
                   begin
                      if (pclkd3)
                         dvalidenvd2 <= dvalidenvd1;
                      else
                         dvalidenvd2 <= dvalidenvd2;
                   end
		end
	end

// *** Modified for synchronization ***
// oimmnt => vp_clk

// counter for pixel count, line clock, horizontal envelopes
// *** Modified for synchronization ***
// !dimresetb => !dimmntsynth
// rx_VP_PCLK => vp_clk
// Had to combine some always blocks here!!!


	assign pixlim = (inthz30) ? `PIXLIM30 : `PIXLIM25;

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  rvenv0 <= 0;
                  rvenv1 <= 0;
                  rvenv2 <= 0;
                  rvenv3 <= 0;
                  rvenv0_int = 0;
                  rvenv1_int = 0;
                  rvenv2_int = 0;
                  rvenv3_int = 0;
                  rvenv4 <= 0;
                  rsgseenv = 0;
                  rsflag <= 0;
                  olcnt <= 0;
                  olcnt_int <= 0;
                  oimmnt = 0;
                  oimmnt_edge <= 0;
                  ipcnt <= 0;
                  dvalidenv <= 0;
                  lefthalf <= 0;
//                  lefthalfd2 <= 0;
                  lefthalfd1 <= 0;
                  dvalidenv_int = 0;
                  lefthalf_int = 0;
                  lefthalfd2_int = 0;
                  lefthalfd1_int = 0;
                  web1 <= 1;
                  web2 <= 1;
                  web3 <= 1;
	              rceb0 <= 1;
	              ceb1 <= 1;
	              ceb2 <= 1;
	              ceb3 <= 1;
		end
                else
                begin
                  if (rx_VP_PCLK)
                  begin
//                    lefthalfd2 <= lefthalfd1;
                    lefthalfd2_int = lefthalfd1_int;
                    lefthalfd1 <= lefthalf;
                    lefthalfd1_int = lefthalf_int;
                    if(((ipcnt + 1) & 511) >= pixlim || dimmntsynth)
                    begin
                      ipcnt <= 0;
                      dvalidenv <= 0;
                      lefthalf <= 0;
                      dvalidenv_int = 0;
                      lefthalf_int = 0;
                    end
                    else if(((ipcnt + 1) & 511) <= `IHSIZED2)
                    begin
                      ipcnt <= (ipcnt + 1);
                      dvalidenv <= 1;
                      lefthalf <= 1;
                      dvalidenv_int = 1;
                      lefthalf_int = 1;
                    end
                    else if(((ipcnt + 1) & 511) <= `IHSIZE)
                    begin
                      ipcnt <= (ipcnt + 1);
                      dvalidenv <= 1;
                      lefthalf <= 0;
                      dvalidenv_int = 1;
                      lefthalf_int = 0;
                    end
                    else if(((ipcnt + 1) & 511) <= `SAFEVAL)
                    begin
                      ipcnt <= (ipcnt + 1);
                      dvalidenv <= 0;
                      lefthalf <= 1;
                      dvalidenv_int = 0;
                      lefthalf_int = 1;
                    end
                    else
                    begin
                      ipcnt <= (ipcnt + 1);
                      dvalidenv <= 0;
                      lefthalf <= 0;
                      dvalidenv_int = 0;
                      lefthalf_int = 0;
                    end
                  end
/*                  if(dimmntsynth)
                  begin
                    ipcnt <= 0;
                    dvalidenv <= 0;
                    lefthalf <= 0;
                    dvalidenv_int = 0;
                    lefthalf_int = 0;
		  end
*/                  oimmnt = dvalidenv_int & lefthalfd2_int & !lefthalfd1_int;
                  if ((oimmnt) & (!oimmnt_edge))
                  begin
                    rvenv0 <= ivenv;
                    rvenv0_int = ivenv;
                    if((ilcnt >= (`IVSTART + 1)) && (ilcnt < (`IVSTART + `IVSIZE - 1))) begin
                      rvenv1 <= 1;
                      rvenv1_int = 1;
                    end else begin
                      rvenv1 <= 0;
                      rvenv1_int = 0;
                    end 
                    if((ilcnt >= (`IVSTART + 2)) && (ilcnt < (`IVSTART + `IVSIZE - 1))) begin
                      rvenv2 <= 1;
                      rvenv2_int = 1;
                    end else begin
                      rvenv2 <= 0;
                      rvenv2_int = 0;
                    end 
                    if((ilcnt >= (`IVSTART + 3)) && (ilcnt < (`IVSTART + `IVSIZE - 1))) begin
                      rvenv3 <= 1;
                      rvenv3_int = 1;
                    end else begin
                      rvenv3 <= 0;
                      rvenv3_int = 0;
                    end 
                    if((ilcnt >= (`IVSTART + 4)) && (ilcnt < (`IVSTART + `IVSIZE - 1))) begin
                      rvenv4 <= 1;
                    end else begin
                      rvenv4 <= 0;
                    end 
                    olcnt <= ilcnt;
                    olcnt_int <= ilcnt;
                  end
                  oimmnt_edge <= oimmnt;
                  if (intqcif) rsgseenv = rvenv1_int; else rsgseenv = rvenv3_int;
                  if (vjog) rsflag <= !(rsgseenv & olcnt_int[0]); else rsflag <= (rsgseenv & olcnt_int[0]);
                  web1c = 1;
                  web2c = 1;
                  web3c = 1;
                  web1q = 1;
                  web2q = 1;
                  web3q = 1;
                  if (rx_VP_PCLK | pclkd1) begin
                    if (mdvalidenvdel & rvenv0_int) web1c = 0;
                    if (mdvalidenvdel & rvenv1_int) web2c = 0;
                    if (mdvalidenvdel & rvenv2_int) web3c = 0;
                    web1q = web1c;
                    web2q = web2c;
                    web3q = web3c;
                    if (qwinhenv & !rsflag)
                    begin
                      web1q = 1;
                      web2q = 1;
                      web3q = 1;
                    end
                    web1 <= intqcif ? web1q : web1c;
                    web2 <= intqcif ? web2q : web2c;
                    web3 <= intqcif ? web3q : web3c;
                  end else begin
                    web1 <= 1;
                    web2 <= 1;
                    web3 <= 1;
                  end
	              rceb0 <= !(pclkd3 & mdvalidenv & rvenv0);
	              wceb1c = !(pclkd1 & mdvalidenvdel & rvenv0);
	              wceb2c = !(pclkd1 & mdvalidenvdel & rvenv1);
	              wceb3c = !(pclkd1 & mdvalidenvdel & rvenv2);
	              rceb1c = !(pclkd3 & mdvalidenv & rvenv1);
	              rceb2c = !(pclkd3 & mdvalidenv & rvenv2);
	              rceb3c = !(pclkd3 & mdvalidenv & rvenv3);
	              wceb1q = (qwinhenv & !rsflag) ? 1 : wceb1c;
	              wceb2q = (qwinhenv & !rsflag) ? 1 : wceb2c;
	              wceb3q = (qwinhenv & !rsflag) ? 1 : wceb3c;
	              rceb1 = rceb1c;
	              rceb2 = rceb2c;
	              rceb3 = rceb3c;
	              wceb1 = intqcif ? wceb1q : wceb1c;
	              wceb2 = intqcif ? wceb2q : wceb2c;
	              wceb3 = intqcif ? wceb3q : wceb3c;
	              ceb1 <= wceb1 & rceb1;
	              ceb2 <= wceb2 & rceb2;
	              ceb3 <= wceb3 & rceb3;
		end
	end

// data envelopes into output processor
	assign vlenv = intqcif ? rvenv4 : rvenv3;
	assign oenv = intqcif ? rvenv4 & odvalidenvdel : rvenv3 & odvalidenv;
	assign menv = rvenv3 & mdvalidenvd2;
//    assign henv = intqcif ? (odvalidenvdel & (olcnt[0] == (`IVSTART & 1))) : odvalidenv;

// CIF RAM0 write address
// *** Modified for synchronization ***
// rx_VP_PCLK => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  waddrbits <= 0;
                  waddr0c <= 0;
		end
                else
                begin
                  if (rx_VP_PCLK)
                  begin
                    if(dimmntenv)
                    begin
                      waddrbits <= 255;
                    end
                    else if(lefthalf && !lefthalfd1)
                    begin
                      waddrbits <= 0;
                    end
                    else if(!lefthalf && lefthalfd1)
                    begin
                      waddrbits <= 0;
                    end
                    else
                    begin
                      waddrbits <= (waddrbits + 1);
                    end
                    waddr0c <= waddr0cearly;
                  end
		end
	end
	assign waddrlsb = evenfirst ? !lefthalfd1 : lefthalfd1;
	assign waddr0cearly = {waddrbits,waddrlsb};
// QCIF RAM0 write address, LSB swap for red lines
	assign waddr0q = {waddr0c[8:1],(rflag ? !waddr0c[0] : waddr0c[0])};

// data envelope to RAMs
	assign ienv = dvalidenvd1 & ivenv;

// CIF RAM0 read address (+ all other addresses for CIF)

// *** Modified for synch: pclkd2_posen => pclkd2

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			raddr0c <= 0;
			odvalidenvdel <= 0;
			odvalidenv <= 0;
			mdvalidenv <= 0;
		end else begin
                  if (pclkd2)
                     begin
			if(oimmnt_edge) begin
				raddr0c <= 511;
			end else begin
				raddr0c <= (raddr0c + 1);
			end
			if(((raddr0c + 1) & 511) < `IHSIZE)
				mdvalidenv <= 1;
			else
				mdvalidenv <= 0;
			odvalidenvdel <= odvalidenv;
			if(((raddr0c + 1) & 511) >= 4 && (raddr0c + 1) < `IHSIZE)
				odvalidenv <= 1;
			else
				odvalidenv <= 0;
                     end
                  else
                     begin
                        raddr0c       <= raddr0c;
                        mdvalidenv    <= mdvalidenv;
                        odvalidenvdel <= odvalidenvdel;
                        odvalidenv    <= odvalidenv;
                     end
                  end
	end

// CIF wceb1 envelope and actual
// *** Modified for synchronization ***
// vp_clk_n => vp_clk

// pclkd3n_posen => pclkd3

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			mdvalidenvdel <= 1;
		end else begin
                   begin
                      if (pclkd3)
                         mdvalidenvdel <= mdvalidenv;
                      else
                         mdvalidenvdel <= mdvalidenvdel;
                   end
		end
	end
// component of menv, extra env to shut down o/p rams
// *** Modified for synchronization ***
// rx_VP_PCLK => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  mdvalidenvd2 <= 1;
		end
                else
                begin
                  if (rx_VP_PCLK) mdvalidenvd2 <= mdvalidenvdel;
		end
	end

// composite ceb output (OR in -ve logic)
	assign ceb0 = wceb0 & rceb0;

// output read & write addresses
	assign raddr0 = raddr0c;
	assign waddr0 = intqcif ? waddr0q : waddr0c;
	assign addr0 = web0 ? raddr0 : waddr0;
	assign addr1 = raddr0c;

// clocks to catch ram outputs
//	assign rcatch0 = (pclkn & mdvalidenv & rvenv0);
//	assign rcatch1 = (pclkn & mdvalidenv & rvenv1);
//	assign rcatch2 = (pclkn & mdvalidenv & rvenv2);
//	assign rcatch3 = (pclkn & mdvalidenv & rvenv3);

        assign rcatch0_posen = ((pclkd4 & mdvalidenv & rvenv0) & (!rcatch0));
        assign rcatch1_posen = ((pclkd4 & mdvalidenv & rvenv1) & (!rcatch1));
        assign rcatch2_posen = ((pclkd4 & mdvalidenv & rvenv2) & (!rcatch2));
        assign rcatch3_posen = ((pclkd4 & mdvalidenv & rvenv3) & (!rcatch3));

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			rcatch0 <= 0;
			rcatch1 <= 0;
			rcatch2 <= 0;
			rcatch3 <= 0;
		end else begin
			rcatch0 <= (pclkd4 & mdvalidenv & rvenv0);
			rcatch1 <= (pclkd4 & mdvalidenv & rvenv1);
			rcatch2 <= (pclkd4 & mdvalidenv & rvenv2);
			rcatch3 <= (pclkd4 & mdvalidenv & rvenv3);
		end 	
	end

// used for bar code generation
	assign baraddr = waddr0cearly;

// RTB interpolation controls
//	assign rsgseenv = intqcif ? rvenv1 : rvenv3;
//	assign rsflag = vjog ? !(rsgseenv & olcnt[0]) : (rsgseenv & olcnt[0]);
	assign gseflagearly = mdvalidenv & rsgseenv & ((vjog != (evenfirst == hjog)) != (raddr0c[0] == olcnt[0]));
	assign ramadd = rsflag & !gseflagearly;

// *** Modified for synchronization ***
// rx_VP_PCLK => vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  gseflag <= 0;
		end
                else
                begin
                  if (rx_VP_PCLK) gseflag <= (intqcif & rsflag) ? 0 : rvenv3 & gseflagearly;
		end
	end

// QCIF write inhibit envelopes
// *** Modified for synchronization ***
// vp_clk_n => vp_clk

// pclkd3n_posen => pclkd3

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			qwinhenv <= 0;
		end else begin
                   begin
                      if (pclkd3)
                         qwinhenv <= gseflagearly;
                      else
                         qwinhenv <= qwinhenv;
                   end
		end
	end

// QCIF line killer (like inverse of old 4:2:0 CIF uvline)
    assign qlinekill = !(rvenv3 & (olcnt[0] == (`IVSTART & 1)));

// frame-grab controls as eventually specified 
// decoding off input line & pixel counters, least inelegant option
// Rec-656 codes decoded off output line counter
    assign qtest656 = hz30 ? (`IHSIZED2 + `IHSIZE + 10) - `PIXLIM30
                            : (`IHSIZED2 + `IHSIZE + 10) - `PIXLIM25;
    assign ctest656 = hz30 ? (`IHSIZED2 + `IHSIZE + 7) - `PIXLIM30
                            : (`IHSIZED2 + `IHSIZE + 7) - `PIXLIM25;

// changes were at pclkd3, now at pclkd4
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
            flenv <= 0;
            llenv <= 0;
			f_int <= 0;
			fst <= 0;
			lst <= 0;
		end else begin
            flenv <= pclkd4 ? (intqcif ? (((((ipcnt + 1) & 511) >= `IHSIZED2 + 10)
                                            || (((ipcnt + 1) & 511) < qtest656))
                                            && ((!vsolid && olcnt == `IVSTART + 2)
                                                || (vsolid && ((olcnt < `IVSTART + 1
                                                    || olcnt >= `IVSTART + `IVSIZE-3)
                                                    && (olcnt[0] == (`IVSTART & 1))))))
                                        : (((((ipcnt + 1) & 511) >= `IHSIZED2 + 9)
                                            || (((ipcnt + 1) & 511) < ctest656))
                                            && ((!vsolid && olcnt == `IVSTART + 1)
                                                || (vsolid && (olcnt < `IVSTART + 2
                                                    || olcnt >= `IVSTART + `IVSIZE-2)))))
                            : flenv;
            llenv <= pclkd4 ? (intqcif ? (((((ipcnt + 1) & 511) >= `IHSIZED2 + 10)
                                                || (((ipcnt + 1) & 511) < qtest656))
                                            && ((!vsolid && (olcnt >= `IVSTART + 3
                                                 && olcnt < `IVSTART + `IVSIZE-1
                                                    && (olcnt[0] == (`IVSTART & 1))
                                                    || (olcnt == `IVSTART + 2)))
                                                || (vsolid && olcnt[0] == (`IVSTART & 1))))
                                        : (((((ipcnt + 1) & 511) >= `IHSIZED2 + 9)
                                                || (((ipcnt + 1) & 511) < ctest656))
                                            && ((!vsolid && (olcnt >= `IVSTART + 3
                                                 && olcnt < `IVSTART + `IVSIZE-1
                                                    || (olcnt == `IVSTART + 1)))
                                                || (vsolid))))
                            : llenv;
            f_int <= pclkd4 ? (intqcif ? ((((ipcnt + 1) & 511) >= `IHSIZED2 - 2)
                                            && (((ipcnt + 1) & 511) < `IHSIZED2 + 10)
                                            && ilcnt == `IVSTART + 1)
                                       : ((((ipcnt + 1) & 511) >= `IHSIZED2 + 3)
                                            && (((ipcnt + 1) & 511) < `IHSIZED2 + 9)
                                            && ilcnt == `IVSTART + 1))
                            : f_int;
            fst <= pclkd4 ? (stndrd ? (intqcif ? ((((ipcnt + 1) & 511) == `IHSIZED2 - 2) ? 
                                                     ((ilcnt >= `IVSTART + `IVSIZE) || (ilcnt < 4)) : fst)
                                               : ((((ipcnt + 1) & 511) == `IHSIZED2 + 3) ?
                                                     ((ilcnt >= `IVSTART + `IVSIZE) || (ilcnt < 1)) : fst))
                                    : (intqcif ? ((((ipcnt + 1) & 511) >= `IHSIZED2 - 2)
                                                     && (((ipcnt + 1) & 511) < `IHSIZED2 + 10)
                                                     && ilcnt == `IVSTART + 2)
                                               : ((((ipcnt + 1) & 511) >= `IHSIZED2 + 3)
                                                     && (((ipcnt + 1) & 511) < `IHSIZED2 + 9)
                                                     && ilcnt == `IVSTART + 2)))
                          : fst;
            lst <= pclkd4 ? (intqcif ? ((((ipcnt + 1) & 511) >= `IHSIZED2 - 2)
                                            && (((ipcnt + 1) & 511) < `IHSIZED2 + 10)
                                            && (vsolid
                                               || (ilcnt >= `IVSTART + 3 && ilcnt < `IVSTART + `IVSIZE-1))
                                            && (ilcnt[0] == (`IVSTART & 1)))
                                     : ((((ipcnt + 1) & 511) >= `IHSIZED2 + 3)
                                            && (((ipcnt + 1) & 511) < `IHSIZED2 + 9)
                                            && (vsolid
                                               || (ilcnt >= `IVSTART + 3 && ilcnt < `IVSTART + `IVSIZE-1))))
                          : lst;
        end
    end

// rx_VP_PCLK chain
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			pclkd4 <= 0;
			pclkd3 <= 0;
			pclkd2 <= 0;
			pclkd1 <= 0;
		end else begin
			pclkd4 <= rx_VP_PCLK ? 0 : pclkd3;
			pclkd3 <= rx_VP_PCLK ? 0 : pclkd2;
			pclkd2 <= rx_VP_PCLK ? 0 : pclkd1;
			pclkd1 <= rx_VP_PCLK;
		end 	
	end

endmodule

