/*
 *  Description: Video Engine Clock Generator.
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : VPCLKGEN
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

module VPCLKGEN (VP_CLK, RESETB, PHASECLK, TOPNIBBLE, VP_PCLK, DISABLECLK);
input VP_CLK, RESETB,  PHASECLK, TOPNIBBLE, DISABLECLK;
output VP_PCLK;

reg VP_PCLK, TNIBBLE;
wire ASYNCTNIB;

always @ (posedge PHASECLK or negedge RESETB) begin
  if (!RESETB)
    TNIBBLE <= 1'b0;
  else
    TNIBBLE <= TOPNIBBLE;
end

assign ASYNCTNIB = TNIBBLE & PHASECLK;

always @ (posedge VP_CLK or negedge RESETB) begin
  if (!RESETB)
    VP_PCLK <= 1'b0;
  else if (DISABLECLK) 
    VP_PCLK <= 1'b1;
  else
    VP_PCLK <= ASYNCTNIB;
end

endmodule //
