/*
 *  Description: Receiver module top level
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : RECEIVER
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

module RECEIVER (
                 clk14, 
                 rx_sftrst_n, 
                 vi, 
                 INHIBIT_96, 
                 CLKDIV,
                 BYTE_ERROR, 
                 NIBBLE_ERROR, 
                 LINE_NUMBER, 
                 LINE_CODE,
                 SENSOR_CLOCK,  
                 DATA_OUT, 
                 DATA_VALID, 
                 DATA_VALID_PRE, 
                 DATA_VALID_POSEN, 
                 DATA_IMMINENT,
                 HOT_PHASEIN, 
                 HOT_PHASEOUT, 
                 PHASE_ERROR, 
                 NO_CAMERA, 
                 vp_clk, 
                 VP_CLOCKME,
                 rx_VP_PCLK, 
                 OVERRIDE, 
                 SOFDATA_OUT, 
                 SOFDATA_VALID, 
                 SOFDATA_VALID_negen, 
                 SOFDATA_IMMINENT, 
                 PIXEL_COUNT, 
                 rstxxa_n, 
                 ERROR_MASK);

input  [3:0] vi;

input  [1:0] CLKDIV, 
             HOT_PHASEIN;

input        clk14, 
             rx_sftrst_n, 
             rstxxa_n, 
             INHIBIT_96, 
             ERROR_MASK;

input        VP_CLOCKME, 
             OVERRIDE;

output [7:0] DATA_OUT, 
             SOFDATA_OUT;

output [2:0] LINE_CODE;

output [8:0] LINE_NUMBER;

output [8:0] PIXEL_COUNT;

output       DATA_VALID, 
             DATA_VALID_PRE, 
             DATA_VALID_POSEN, 
             DATA_IMMINENT, 
             PHASE_ERROR;

output       SOFDATA_VALID, 
             SOFDATA_VALID_negen, 
             SOFDATA_IMMINENT;

output       NIBBLE_ERROR, 
             BYTE_ERROR, 
             SENSOR_CLOCK;

output       NO_CAMERA, 
             vp_clk, 
             rx_VP_PCLK;

output [1:0] HOT_PHASEOUT;

wire   [3:0] gooddata;
wire   [7:0] BYTEDATA;
wire   [7:0] DATAOUT, 
             SOFDATAOUT;
wire   [2:0] CODE;
wire   [8:0] LINENUM;
wire   [3:0] DATA;
wire   [1:0] CLKDIV;
wire   [1:0] HOT_PHASEIN, 
             HOT_PHASEOUT;
wire   [8:0] PIXCOUNT, 
             PIXEL_COUNT;
wire         NEWSYNC, 
             FIRSTFRAME, 
             NO_CAMERA, 
             FRAMEERR, 
             REALFRAMEERR, 
             FRAMELOCKEN, 
             OUTPUTDATAEN;
wire         CLK, 
             rx_sftrst_n, 
             INHIBIT_96, 
             PHASE0, 
             VALID, 
             IMMINENT, 
             SYNCCOMP,
             FAST_CLOCK,
             RUNFRAMELOCK;
wire         vp_clk, 
             vp_clk_n, 
             enph0, 
             VP_CLOCKME, 
             VP_CLKEN, 
             SOF;
wire         ABANDONFRAME, 
             TOPNIBBLE, 
             rx_VP_PCLK, 
             INTVP_PCLK, 
             OVERRIDE;
wire         SOFVALID, 
             SOFIMMINENT, 
             DISABLECLK, 
             ERROR_MASK;

reg          FASTFORWARDMODE;

//RESETB is (rx_sftrst_n & rstxxa_n)
//assign BYTERESETB =  RESETB & ~NO_CAMERA;

// Clock in ERROR_MASK, reset on RESETB or SOF.
always @(posedge vp_clk or negedge rstxxa_n)
begin
   if (!rstxxa_n)
      FASTFORWARDMODE <= 1'b0;
   else
      if (~rx_sftrst_n)
         FASTFORWARDMODE <= 1'b0;
      else
         if (enph0)
            if (SOF)
               FASTFORWARDMODE <= 1'b0;
            else
               if (ERROR_MASK)
                  FASTFORWARDMODE <= 1'b1;
               else
                  FASTFORWARDMODE <= FASTFORWARDMODE;
         else
            FASTFORWARDMODE <= FASTFORWARDMODE;
end
         
NIBCONV         nib (
                     .vp_clk(vp_clk), 
                     .enph0(enph0), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .gooddata(gooddata), 
                     .FIRSTFRAME(FIRSTFRAME), 
                     .NEWFRAME(SOF), 
                     .OUTPUTDATAEN(OUTPUTDATAEN),
                     .BYTESYNCERR(NIBBLE_ERROR), 
                     .BYTEDATA(BYTEDATA), 
                     .NIBBLESYNC(NIBBLESYNC), 
                     .SYNCSEQ(NEWSYNC), 
                     .TOPNIBBLE(TOPNIBBLE),
                     .FASTFORWARDMODE(FASTFORWARDMODE)
                    );
                
BYTEDEC        byte (
                     .vp_clk(vp_clk), 
                     .enph0(enph0), 
                     .enph2(enph2), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .NO_CAMERA(NO_CAMERA), 
                     .DATA(BYTEDATA), 
                     .NIBSYNC(NIBBLESYNC), 
                     .NEWSYNC(NEWSYNC), 
                     .FRAMEERR(REALFRAMEERR),
                     .BYTE_ERROR(BYTE_ERROR), 
                     .LINE_NUMBER(LINENUM), 
                     .LINE_CODE(CODE), 
                     .DATA_OUT(DATAOUT), 
                     .DATA_VALID(VALID), 
                     .DATA_IMMINENT(IMMINENT),
                     .SOBL(SOBL), 
                     .SOBK(SOBK), 
                     .SOVL(SOVL), 
                     .SOF(SOF), 
                     .EOF(EOF),	
                     .SOFDATA_OUT(SOFDATAOUT), 
                     .SOFDATA_VALID(SOFVALID),
                     .SOFDATA_IMMINENT(SOFIMMINENT), 
                     .COUNT(PIXCOUNT), 
                     .FASTFORWARDMODE(FASTFORWARDMODE)
                    );

CONTRSM         ctl (
                     .FFCOUNT(FFCOUNT), 
                     .ZEROCOUNT(ZEROCOUNT), 
                     .INHIBIT_96(INHIBIT_96), 
                     .SOF(SOF), 
                     .EOF(EOF), 
                     .SOBL(SOBL), 
                     .SOBK(SOBK), 
                     .SOVL(SOVL), 
                     .vp_clk(vp_clk), 
                     .enph0(enph0), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .SYNCCOMP(SYNCCOMP), 
                     .FIRSTFRAME(FIRSTFRAME), 
                     .NOCAMERA(NO_CAMERA), 
                     .FRAMEERR(FRAMEERR), 
                     .FRAMELOCKEN(FRAMELOCKEN), 
                     .OUTPUTDATAEN(OUTPUTDATAEN)
                    );

CAMDET          cam (
                     .gooddata(gooddata), 
                     .vp_clk(vp_clk), 
                     .enph0(enph0), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .ZEROCOUNT(ZEROCOUNT), 
                     .FFCOUNT(FFCOUNT)
                    );

CLKDIVIDER   clkgen (
                     .clk14(clk14), 
                     .rstxxa_n(rstxxa_n), 
                     .CLKDIV(CLKDIV), 
                     .vp_clk(vp_clk),
                     .vp_clk_n(vp_clk_n)
                    );
 
allph_syncdet phsel (
                     .vp_clk(vp_clk), 
                     .vp_clk_n(vp_clk_n), 
                     .rstxxa_n(rstxxa_n),         //Asynchronous
                     .rx_sftrst_n(rx_sftrst_n),   //Asynchronous
                     .vi(vi),                     //Asynchronous
                     .runframelock(RUNFRAMELOCK), //clocked by vp_clk
                     .hotphasein(HOT_PHASEIN),    //clocked by clk14
                     .override(OVERRIDE),         //clocked by clk14
                     .enph0(enph0),               //clocked by vp_clk
                     .enph2(enph2),               //clocked by vp_clk
                     .gooddata(gooddata),         //clocked by vp_clk
                     .fail(PHASE_ERROR),          //clocked by vp_clk
                     .hotphaseout(HOT_PHASEOUT)   //clocked by vp_clk
                    );


// Clock in Module VPCKDAT changed by Arnaud

VPCKDAT       vpdat (
                     .vp_clk(vp_clk), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .enph0(enph0), 
                     .DATAIN(DATAOUT), 
                     .CODEIN(CODE), 
                     .NUMBERIN(LINENUM), 
                     .VALIDIN(VALID), 
                     .IMMINENTIN(IMMINENT), 
                     .ABANDONFRAME(ABANDONFRAME), 
                     .SOFDATAIN(SOFDATAOUT), 
                     .SOFVALIDIN(SOFVALID), 
                     .SOFIMMINENTIN(SOFIMMINENT), 
                     .PIXCOUNTIN(PIXCOUNT),
                     .DATA_OUT(DATA_OUT), 
                     .LINE_CODE(LINE_CODE), 
                     .LINE_NUMBER(LINE_NUMBER), 
                     .DATA_VALID(DATA_VALID),
                     .DATA_VALID_PRE(DATA_VALID_PRE),
                     .DATA_VALID_POSEN(DATA_VALID_POSEN),
                     .DATA_IMMINENT(DATA_IMMINENT), 
                     .SOFDATA_OUT(SOFDATA_OUT), 
                     .SOFDATA_VALID(SOFDATA_VALID), 
                     .SOFDATA_VALID_negen(SOFDATA_VALID_negen), 
                     .SOFDATA_IMMINENT(SOFDATA_IMMINENT),
                     .PIXEL_COUNT(PIXEL_COUNT)
                    );

PLCOUNT      pxlcnt (
                     .vp_clk(vp_clk), 
                     .enph0(enph0), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .FRAMELOCKEN(FRAMELOCKEN), 
                     .SYNCCOMP(SYNCCOMP), 
                     .RUNFRAMELOCK(RUNFRAMELOCK)
                    );
 
pxlclkgen   pclkgen (
                     .vp_clk(vp_clk), 
                     .enph0(enph0), 
                     .enph2(enph2), 
                     .rstxxa_n(rstxxa_n), 
                     .rx_sftrst_n(rx_sftrst_n), 
                     .NO_CAMERA(NO_CAMERA), 
                     .VP_CLOCKME(VP_CLOCKME), 
                     .TOPNIBBLE(TOPNIBBLE), 
                     .rx_VP_PCLK(rx_VP_PCLK)
                    );

// Blank out FRAMERR here if ERROR_MASK is set.
assign REALFRAMEERR = FRAMEERR & ~FASTFORWARDMODE;
// Abandon frame turns off output on byte or nibble error
// Note these will not be flagged if ERROR_MASK is set.
assign ABANDONFRAME = BYTE_ERROR | NIBBLE_ERROR | REALFRAMEERR;

assign SENSOR_CLOCK = enph2;

//
///// Commented out for now. Will add logic to enable later
///// if necessary
//
// Create VP_CLK and VP_PCLK but only when camera present or clk is asked for.
//
//assign VP_CLKEN = (~NO_CAMERA) | VP_CLOCKME;
//assign VP_CLK = (VP_CLKEN) ? INTVP_CLK : 1'b0;
//assign VP_PCLK = (VP_CLKEN) ? INTVP_PCLK : 1'b0;

endmodule 
