/*
 *  Description: 9-6 detection time-out
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : PLCOUNT
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 25-AUG-97:  runframelock delayed, COUNT extended
*/



module PLCOUNT (
                vp_clk, 
                enph0, 
                rstxxa_n, 
                rx_sftrst_n, 
                FRAMELOCKEN, 
                SYNCCOMP, 
                RUNFRAMELOCK
               );

input        vp_clk, 
             enph0, 
             rstxxa_n, 
             rx_sftrst_n, 
             FRAMELOCKEN;
output       SYNCCOMP, 
             RUNFRAMELOCK;

reg   [13:0] COUNT;
reg          RUNFRAMELOCK, 
             SYNCCOMP;

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         COUNT <= 14'h0;
      else
         if (!rx_sftrst_n)
            COUNT <= 14'h0;
         else
            if (enph0)
               if (FRAMELOCKEN)
                  COUNT <= COUNT + 1;
               else
                  COUNT <= 14'h0;
            else
               COUNT <= COUNT;
   end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         begin
            RUNFRAMELOCK <= 1'b0;
            SYNCCOMP     <= 1'b0;
         end
      else
         if (!rx_sftrst_n)
            begin
               RUNFRAMELOCK <= 1'b0;
               SYNCCOMP     <= 1'b0;
            end
         else
            if (enph0)
               begin
               // COUNT value set to 4096 before starting phase locking
                  if (COUNT == 14'h1000)
                     begin
                        RUNFRAMELOCK <= 1'b1;
                        SYNCCOMP     <= 1'b0;
                     end
                  else
                     if (COUNT == 14'h3800)
                        begin
                           RUNFRAMELOCK <= 1'b0;
                           SYNCCOMP     <= 1'b1;
                        end
                     else
                        begin
                           RUNFRAMELOCK <= RUNFRAMELOCK;
                           SYNCCOMP     <= 1'b0;
                        end
               end
            else
               begin
                  RUNFRAMELOCK <= RUNFRAMELOCK;
                  SYNCCOMP     <= SYNCCOMP;
               end
   end	 



endmodule 
