/*
 *  Description: 6-bit Parity check
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : PARITY6
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

// O is output high if parity is correct

module PARITY6 (DIN, P, O);

  input [5:0] DIN;
  input P;
  output O;
  wire W1, W2;

  assign W1 = (DIN[0] ^ DIN[1]) ^ (DIN[2] ^ DIN[3]) ;
  assign W2 = W1 ^ (DIN[4] ^ DIN[5]);
  assign O = W2 ^ P;

endmodule
