/*
 *  Description: 4-bit Parity Generator
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : PARITY4
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

// A, B, C are Command Bits , P is Parity Bit
// O is output high if even number of ones in inputs (ie. input is correct)

module PARITY4 (A, B, C, P, O);

  input  A, B, C, P;
  output O;
  wire W1;

  PARITY3 U1 (.O(W1), .A(A), .B(B), .P(C));

  assign O = W1 ^ P;

endmodule
