/*
 *  Description: 3-bit Parity generator
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : PARITY3
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

// A, B are Command Bits , P is Parity Bit
// O is output high if even number of ones in inputs (ie. input is correct)

module PARITY3 (A, B, P, O);

  input  A, B, P;
  output O;
  wire W1;

  assign W1 = A ~^ B;
  assign O = W1 ^ P;

endmodule
