/*
 *  Description: Camera Nibble->byte Converter
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : NIBCONV
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



module NIBCONV (
                vp_clk, 
                enph0, 
                rstxxa_n, 
                rx_sftrst_n, 
                gooddata, 
                FIRSTFRAME, 
                NEWFRAME, 
                OUTPUTDATAEN,
                BYTESYNCERR, 
                BYTEDATA, 
                NIBBLESYNC, 
                SYNCSEQ, 
                TOPNIBBLE,
                FASTFORWARDMODE
               );


input        vp_clk, 
             enph0, 
             rstxxa_n, 
             rx_sftrst_n; 
input  [3:0] gooddata;
input        NEWFRAME, 
             FIRSTFRAME;
input        OUTPUTDATAEN, 
             FASTFORWARDMODE;
output       BYTESYNCERR, 
             NIBBLESYNC, 
             SYNCSEQ, 
             TOPNIBBLE;
output [7:0] BYTEDATA;

reg          TOPNIBBLE, 
             BYTESYNCERR;  
reg          INVNIB, 
             SMSYNC;
reg    [3:0] LASTVAL, 
             PREVDATA;
reg    [3:0] DATA;
reg    [3:0] BYTEDAT;
reg    [7:0] BYTEDATA;
reg          CK1, 
             PREVLASTVAL, 
             PREVLVAND1, 
             PREVLVAND2;
reg          SWITCHCK;

wire         SYNCNIB, 
             NIBBLESYNC, 
             SYNCSEQ;

always @ (posedge vp_clk or negedge rstxxa_n)
begin
   if (!rstxxa_n)
      DATA <= 4'b0000;
   else
      if (~rx_sftrst_n)
         DATA <= 4'b0000;
      else
         if (enph0)
            DATA <= gooddata;
         else
            DATA <= DATA;
end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         begin
            PREVDATA    <= 4'b0000;
            LASTVAL     <= 4'b0000;
            PREVLASTVAL <= 1'b0;
            PREVLVAND1  <= 1'b0;
            PREVLVAND2  <= 1'b0;
         end
      else
	  if (!rx_sftrst_n)
             begin
                PREVDATA    <= 4'b0000;
                LASTVAL     <= 4'b0000;
                PREVLASTVAL <= 1'b0;
                PREVLVAND1  <= 1'b0;
                PREVLVAND2  <= 1'b0;
             end
	  else
             if (enph0)
                begin 
		   PREVDATA    <= DATA;
		   LASTVAL     <= PREVDATA;
		   PREVLASTVAL <= &LASTVAL;
		   PREVLVAND1  <= PREVLASTVAL;
		   PREVLVAND2  <= PREVLVAND1;
                end
	     else
		begin 
		   PREVDATA    <= PREVDATA;
		   LASTVAL     <= LASTVAL;
		   PREVLASTVAL <= PREVLASTVAL;
		   PREVLVAND1  <= PREVLVAND1;
		   PREVLVAND2  <= PREVLVAND2;
		end
   end

assign SYNCNIB = PREVLVAND2 & PREVLVAND1 & PREVLASTVAL & (&(LASTVAL & (~PREVDATA) & (~DATA) ));  

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         CK1 <= 1'b0;
      else
         if (!rx_sftrst_n)
            CK1 <= 1'b0;
         else
            if (enph0)
               CK1 <= ~CK1;
            else
               CK1 <= CK1;
   end

// Set up Topnibble value if INVNIB is 0 then CK1, 1 then ~CK1
// arbitrary start with ck1
always @ (CK1 or INVNIB)
begin
   if (INVNIB)
      TOPNIBBLE <= ~CK1;
   else
      TOPNIBBLE <= CK1;
end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         begin
            INVNIB   <= 1'b0;
            SWITCHCK <= 1'b0;
         end
      else
         if (!rx_sftrst_n)
            begin
               INVNIB   <= 1'b0;
               SWITCHCK <= 1'b0;
            end
         else
            if (enph0)
               if (SYNCNIB)
                  begin
                     if (TOPNIBBLE)
                        begin
                           INVNIB <= ~INVNIB;
                           if (FIRSTFRAME || FASTFORWARDMODE)	 
                           // For first transition of first frame do not flag signal
                           // so that we can sync.
                           // Also do not flag error if we are in FASTFORWARDMODE
                              SWITCHCK <= 1'b0;
                           else
                              SWITCHCK <= 1'b1; 
                        end
                     else
                        begin
                           INVNIB <= INVNIB;
                           SWITCHCK <= 1'b0;
                        end
                  end
               else
                  begin
                     INVNIB   <= INVNIB;
                     SWITCHCK <= SWITCHCK;
                  end
            else
               begin
                  INVNIB   <= INVNIB;
                  SWITCHCK <= SWITCHCK;
               end
   end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         BYTESYNCERR <= 1'b0;
      else
         if (!rx_sftrst_n)
            BYTESYNCERR <= 1'b0;
         else
            if (enph0)
               if (SWITCHCK)   
                  BYTESYNCERR <= 1'b1;
               else
                  if (NEWFRAME)
                     BYTESYNCERR <= 1'b0;
                  else
                     BYTESYNCERR <= BYTESYNCERR;
            else
               BYTESYNCERR <= BYTESYNCERR;
   end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         BYTEDAT <= 4'b0000;
      else
         if (!rx_sftrst_n)
            BYTEDAT <= 4'b0000;
         else
            if (enph0)
               BYTEDAT <= DATA;
            else
               BYTEDAT <= BYTEDAT;
   end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n) 
         SMSYNC <= 1'b0;
      else
         if (!rx_sftrst_n)
            SMSYNC <= 1'b0;
         else
            if (enph0)
               SMSYNC <= SYNCNIB;
            else
               SMSYNC <= SMSYNC;
   end

// Signals disabled until after phase lock period
assign SYNCSEQ = (OUTPUTDATAEN) ? SMSYNC : 1'b0;
assign NIBBLESYNC = (OUTPUTDATAEN) ? TOPNIBBLE : 1'b0;

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         BYTEDATA <= 8'b00000000;
      else
         if (!rx_sftrst_n)
            BYTEDATA <= 8'b00000000;
         else
            if (enph0)
               begin
                  if (!TOPNIBBLE)
                     if (OUTPUTDATAEN)
                        BYTEDATA <= {BYTEDAT, DATA};
                     else
                        BYTEDATA <= 8'b00000000;
                  else
                     BYTEDATA <= BYTEDATA;
               end
            else
               BYTEDATA <= BYTEDATA;
   end

endmodule 
