/*
 *  Description: Receiver Control State Machine
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : CONTRSM
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



module CONTRSM (
                FFCOUNT, 
                ZEROCOUNT, 
                INHIBIT_96, 
                SOF, 
                EOF, 
                SOBL, 
                SOBK, 
                SOVL, 
                vp_clk, 
                enph0, 
                rstxxa_n, 
                rx_sftrst_n, 
                SYNCCOMP, 
                FIRSTFRAME, 
                NOCAMERA, 
                FRAMEERR, 
                FRAMELOCKEN, 
                OUTPUTDATAEN
               );
  
// Inputs...
input        FFCOUNT;
input        ZEROCOUNT;
input        INHIBIT_96;
input        SOF;
input        EOF;
input        SOBL;
input        SOBK;
input        SOVL;
input        vp_clk;
input        enph0;
input        rstxxa_n;
input        rx_sftrst_n;
input        SYNCCOMP;
// Outputs (and Inouts) ...
output       FIRSTFRAME;
output       NOCAMERA;
output       FRAMEERR;
output       FRAMELOCKEN;
output       OUTPUTDATAEN;

// Input type declarations
wire         FFCOUNT;
wire         ZEROCOUNT;
wire         INHIBIT_96;
wire         SOF;
wire         EOF;
wire         SOBL;
wire         SOBK;
wire         SOVL;
wire         vp_clk;
wire         enph0;
wire         rstxxa_n;
wire         rx_sftrst_n;
wire         SYNCCOMP;
  
// Output type declarations
reg          FIRSTFRAME;
reg          NOCAMERA;
reg          FRAMEERR;
reg          FRAMELOCKEN;
reg          OUTPUTDATAEN;
  
  
  
// State register values for sm1
parameter sm1_PowerUp=4'b0000, 
          sm1_SensorConnected=4'b0001, 
          sm1_SensorDisconnect=4'b0010, 
          sm1_InLowPower=4'b0011, 
          sm1_SOFWait=4'b0100, 
          sm1_EndSOF=4'b0101, 
          sm1_BlackLines=4'b0110, 
          sm1_BlankLines=4'b0111, 
          sm1_DataError=4'b1000, 
          sm1_VideoLines=4'b1001, 
          sm1_EndOfFrame=4'b1010, 
          sm1_EOFBlankLines=4'b1011, 
          sm1_LeaveError=4'b1100, 
          sm1_LockComplete=4'b1101, 
          sm1_EndFrameLock=4'b1110, 
          sm1_StartFrameLock=4'b1111;


reg    [3:0] CS_sm1;
  
  //
  // Feedbacks and inputs, outputs and
  // inouts with external names if any.
  //
  
  //
  // Finite State Machine description for sm1
  //
always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         begin
            NOCAMERA     <= 1'b0;
            FIRSTFRAME   <= 1'b0;
            FRAMEERR     <= 1'b0;
            OUTPUTDATAEN <= 1'b0;
            FRAMELOCKEN  <= 1'b0;
            CS_sm1       <= sm1_PowerUp;
         end // if RESET triggered  
      else
         if (!rx_sftrst_n)
            begin
               NOCAMERA     <= 1'b0;
               FIRSTFRAME   <= 1'b0;
               FRAMEERR     <= 1'b0;
               OUTPUTDATAEN <= 1'b0;
               FRAMELOCKEN  <= 1'b0;
               CS_sm1       <= sm1_PowerUp;
            end // if RESET triggered  
         else
            if (enph0)
               begin
               // Comment on following line is for synthesis tools
                  case (CS_sm1) // $full
                     sm1_PowerUp:
                        begin
                           NOCAMERA     <= 1'b0;
                           FIRSTFRAME   <= 1'b0;
                           FRAMEERR     <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN  <= 1'b0;
                           if ((FFCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorConnected;
                           else
                              CS_sm1 <= sm1_PowerUp; // Default transition
                        end // State  
   
                     sm1_SensorConnected:
                        begin
                           NOCAMERA     <= 1'b0;
                           FIRSTFRAME   <= 1'b0;
                           FRAMEERR     <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN  <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else
                              CS_sm1 <= sm1_InLowPower;
                        end // State 
   
                     sm1_SensorDisconnect:
                        begin
                           NOCAMERA <= 1'b1;
                           FIRSTFRAME <= 1'b0;
                           FRAMEERR <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN <= 1'b0;
                           if ((FFCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorConnected;
                           else
                              CS_sm1 <= sm1_SensorDisconnect; // Default transition
                        end // State	  
               
                     sm1_InLowPower:
                        begin
                           NOCAMERA <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           FRAMEERR <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN <= 1'b0;
                           if ((INHIBIT_96 == 1'b0))
                              CS_sm1 <= sm1_StartFrameLock;
                           else
                              CS_sm1 <= sm1_InLowPower; // Default transition
                        end // State  
   
                     sm1_SOFWait:
                        begin
                           NOCAMERA <= 1'b0;
                           FIRSTFRAME <= 1'b1;
                           FRAMEERR <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if (((((EOF == 1'b1) | (SOBK == 1'b1)) | (SOBL == 1'b1)) | (SOVL == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((SOF == 1'b1))
                              CS_sm1 <= sm1_EndSOF;
                           else
                              CS_sm1 <= sm1_SOFWait; // Default transition
                        end // State  
   
                     sm1_EndSOF:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if (((((EOF == 1'b1) | (SOF == 1'b1)) | (SOBL == 1'b1)) | (SOVL == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((SOBK == 1'b1))
                              CS_sm1 <= sm1_BlackLines;
                           else
                              CS_sm1 <= sm1_EndSOF; // Default transition
                        end // State	 
   
                     sm1_BlackLines:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if ((((EOF == 1'b1) | (SOF == 1'b1)) | (SOVL == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((SOBL == 1'b1))
                              CS_sm1 <= sm1_BlankLines;
                           else
                              CS_sm1 <= sm1_BlackLines; // Default transition
                        end // State 
   
                     sm1_BlankLines:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if ((((EOF == 1'b1) | (SOF == 1'b1)) | (SOBK == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((SOVL == 1'b1))
                              CS_sm1 <= sm1_VideoLines;
                           else
                              CS_sm1 <= sm1_BlankLines; // Default transition
                        end // State  
   
                     sm1_DataError:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b1;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else
                              CS_sm1 <= sm1_LeaveError;
                        end // State  
   
                     sm1_VideoLines:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if ((((SOF == 1'b1) | (SOBL == 1'b1)) | (SOBK == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((EOF == 1'b1))
                              CS_sm1 <= sm1_EndOfFrame;
                           else
                              CS_sm1 <= sm1_VideoLines; // Default transition
                        end // State 
   
                     sm1_EndOfFrame:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if (((((EOF == 1'b1) | (SOF == 1'b1)) | (SOVL == 1'b1)) | (SOBK == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((SOBL == 1'b1))
                              CS_sm1 <= sm1_EOFBlankLines;
                           else
                              CS_sm1 <= sm1_EndOfFrame; // Default transition
                        end // State  
   
                     sm1_EOFBlankLines:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if ((((EOF == 1'b1) | (SOVL == 1'b1)) | (SOBK == 1'b1)))
                              CS_sm1 <= sm1_DataError;
                           else if ((SOF == 1'b1))
                              CS_sm1 <= sm1_EndSOF;
                           else
                              CS_sm1 <= sm1_EOFBlankLines; // Default transition
                        end // State  
    
                     sm1_LeaveError:
                        begin
                           NOCAMERA <= 1'b0;
                           FRAMEERR <= 1'b0;
                           FIRSTFRAME <= 1'b0;
                           OUTPUTDATAEN <= 1'b1;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if ((SOF == 1'b1))
                              CS_sm1 <= sm1_EndSOF;
                           else
                              CS_sm1 <= sm1_LeaveError; // Default transition
                        end // State
   
                     sm1_LockComplete:
                        begin
                           NOCAMERA <= 1'b0;
                           FIRSTFRAME <= 1'b1;
                           FRAMEERR <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else
                              CS_sm1 <= sm1_EndFrameLock;
                        end // State	  
   
                     sm1_EndFrameLock:
                        begin
                           NOCAMERA <= 1'b0;
                           FIRSTFRAME <= 1'b1;
                           FRAMEERR <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN <= 1'b0;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else
                              CS_sm1 <= sm1_SOFWait;
                        end // State  
   
                     sm1_StartFrameLock:
                        begin
                           NOCAMERA <= 1'b0;
                           FIRSTFRAME <= 1'b1;
                           FRAMEERR <= 1'b0;
                           OUTPUTDATAEN <= 1'b0;
                           FRAMELOCKEN <= 1'b1;
                           if ((ZEROCOUNT == 1'b1))
                              CS_sm1 <= sm1_SensorDisconnect;
                           else if ((SYNCCOMP == 1'b1))
                              CS_sm1 <= sm1_LockComplete;
                           else
                              CS_sm1 <= sm1_StartFrameLock; // Default transition
                        end // State
   
                  endcase
               end // FSM for sm1  
            else  
               begin
                  NOCAMERA     <= NOCAMERA;
                  FIRSTFRAME   <= FIRSTFRAME;
                  FRAMEERR     <= FRAMEERR;
                  OUTPUTDATAEN <= OUTPUTDATAEN;
                  FRAMELOCKEN  <= FRAMELOCKEN;
                  CS_sm1       <= CS_sm1;
               end // State
   end 


endmodule
