/*
 *  Description: Camera Emb. seq. parity check
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : CMDPAR
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

module CMDPAR (DATAIN, DATAOUT, ERROR2BIT);

  input  [7:0]           DATAIN;
  output [3:0]           DATAOUT;
  output ERROR2BIT;

//  wire C2, C1, C0, P3, P2, P1, P0;
  reg [3:0]           DATAOUT;
  reg ERROR2BIT;
//  wire EPARITY0, EPARITY1, EPARITY2, EPARITY3;
  wire [3:0] PARITYRESULT;

//  assign PARITYRESULT = {EPARITY3,EPARITY2,EPARITY1,EPARITY0};

//  assign C2 = DATAIN[6];
//  assign C1 = DATAIN[5];
//  assign C0 = DATAIN[4];
//  assign P3 = DATAIN[3];
//  assign P2 = DATAIN[2];
//  assign P1 = DATAIN[1];
//  assign P0 = DATAIN[0];

//  PARITY4 U0 (.O(EPARITY0), .A(C2), .B(C1), .C(C0), .P(P0));
  PARITY4 U0 (.O(PARITYRESULT[0]), .A(DATAIN[6]), .B(DATAIN[5]), .C(DATAIN[4]), .P(DATAIN[0]));

//  PARITY3 U1 (.O(EPARITY1), .A(C2), .B(C1), .P(P1));
  PARITY3 U1 (.O(PARITYRESULT[1]), .A(DATAIN[6]), .B(DATAIN[5]), .P(DATAIN[1]));

//  PARITY3 U2 (.O(EPARITY2), .A(C2), .B(C0), .P(P2));
  PARITY3 U2 (.O(PARITYRESULT[2]), .A(DATAIN[6]), .B(DATAIN[4]), .P(DATAIN[2]));

//  PARITY3 U3 (.O(EPARITY3), .A(C1), .B(C0), .P(P3));
  PARITY3 U3 (.O(PARITYRESULT[3]), .A(DATAIN[5]), .B(DATAIN[4]), .P(DATAIN[3]));


  always
    @ (PARITYRESULT or DATAIN)
	  case (PARITYRESULT)
	     4'b1111 :
	        begin 
	          DATAOUT <= DATAIN[7:4];
			  ERROR2BIT <= 1'b0;
			end
		 4'b1110 : 
	        begin 
	          DATAOUT <= DATAIN[7:4];
			  ERROR2BIT <= 1'b0;
			end
		 4'b1101 : 
	        begin 
	          DATAOUT <= DATAIN[7:4];
			  ERROR2BIT <= 1'b0;
			end
		 4'b1011 : 
	        begin 
	          DATAOUT <= DATAIN[7:4];
			  ERROR2BIT <= 1'b0;
			end
		 4'b0111 : 
	        begin 
	          DATAOUT <= DATAIN[7:4];
			  ERROR2BIT <= 1'b0;
			end
		 4'b0010 : 
	        begin 
//	          DATAOUT[7] <= DATAIN[7];
//	          DATAOUT[6] <= DATAIN[6];
//	          DATAOUT[5] <= DATAIN[5];
//	          DATAOUT[4] <= ~DATAIN[4];
	          DATAOUT[3] <= DATAIN[7];
	          DATAOUT[2] <= DATAIN[6];
	          DATAOUT[1] <= DATAIN[5];
	          DATAOUT[0] <= ~DATAIN[4];
//	          DATAOUT[3] <= DATAIN[3];
//	          DATAOUT[2] <= DATAIN[2];
//	          DATAOUT[1] <= DATAIN[1];
//	          DATAOUT[0] <= DATAIN[0];
			  ERROR2BIT <= 1'b0;
			end
		 4'b0100 : 
	        begin 
//	          DATAOUT[7] <= DATAIN[7];
//	          DATAOUT[6] <= DATAIN[6];
//	          DATAOUT[5] <= ~DATAIN[5];
//	          DATAOUT[4] <= DATAIN[4];
	          DATAOUT[3] <= DATAIN[7];
	          DATAOUT[2] <= DATAIN[6];
	          DATAOUT[1] <= ~DATAIN[5];
	          DATAOUT[0] <= DATAIN[4];
//	          DATAOUT[3] <= DATAIN[3];
//	          DATAOUT[2] <= DATAIN[2];
//	          DATAOUT[1] <= DATAIN[1];
//	          DATAOUT[0] <= DATAIN[0];
			  ERROR2BIT <= 1'b0;
			end
		 4'b1000 : 
	        begin 
//	          DATAOUT[7] <= DATAIN[7];
//	          DATAOUT[6] <= ~DATAIN[6];
//	          DATAOUT[5] <= DATAIN[5];
//	          DATAOUT[4] <= DATAIN[4];
	          DATAOUT[3] <= DATAIN[7];
	          DATAOUT[2] <= ~DATAIN[6];
	          DATAOUT[1] <= DATAIN[5];
	          DATAOUT[0] <= DATAIN[4];
//	          DATAOUT[3] <= DATAIN[3];
//	          DATAOUT[2] <= DATAIN[2];
//	          DATAOUT[1] <= DATAIN[1];
//	          DATAOUT[0] <= DATAIN[0];
			  ERROR2BIT <= 1'b0;
			end
          default :
	        begin 
	          DATAOUT <= DATAIN[7:4];
			  ERROR2BIT <= 1'b1;
			end
	  endcase

endmodule  
