/*
 *  Description: MHZ14 divider (1,2,4,8)
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : CLKDIVIDER
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

module CLKDIVIDER (
                   clk14, 
                   rstxxa_n, 
                   CLKDIV, 
                   vp_clk,
                   vp_clk_n
                  );

input        clk14, 
             rstxxa_n;
input  [1:0] CLKDIV;

output       vp_clk,
             vp_clk_n;

reg    [2:0] COUNT;
reg          vp_clk;
reg    [1:0] DIVVAL;

wire         vp_clk_n;

assign vp_clk_n = ~vp_clk;

// init for simulation
//initial begin
//  COUNT <= 3'b110;
//end

always @ (posedge clk14 or negedge rstxxa_n)
  if (~rstxxa_n)
    COUNT <= 3'b110;
  else
    COUNT <= COUNT + 1;

// Use count of 6 to clock CLKDIV, such that it's val will be used
// when all clocks are high.

always @ (negedge clk14 or negedge rstxxa_n)
  if (~rstxxa_n)
    DIVVAL <= 1;
  else if (COUNT == 0)
    DIVVAL <= CLKDIV;


always @ (clk14 or COUNT or DIVVAL) begin
  case (DIVVAL)
    2'b00 : vp_clk <= clk14;
    2'b01 : vp_clk <= COUNT[0];
    2'b10 : vp_clk <= COUNT[1];
    2'b11 : vp_clk <= COUNT[2];
  default : vp_clk <= COUNT[0];
  endcase
end

endmodule 
