PROGRAM NoRectangles;  {Problem D 1990}

#include "str.h"

CONST k = 12;
      xbase = 10;
      ybase = 10;
      square = 1;

VAR   n, i, j: integer;
      name: string;
      grid: array[1..150, 1..150] of boolean;

PROCEDURE clear;
VAR i, j: integer;
begin for i := 1 to n do for j := 1 to n do grid[i, j] := false end;

PROCEDURE dump;
VAR i, j: integer;

begin
for i := 1 to n do begin
  for j := 1 to n do
    if grid[i, j] then write(j : 1, ' ');
  writeln end
end;

PROCEDURE mark (i, j: integer);
begin grid[i, j] := true end;

PROCEDURE frame (n, k: integer);
VAR q, r, s, t, u, v, w: integer;

begin
mark(1, 1); {the top, left point}
for s := 1 to k do
  for t := (s - 1) * (k - 1) + 2 to s * (k - 1) + 1 do begin
    mark(s, t); mark(t, s) end;

for u := 1 to k - 1 do
  for v := 1 to k - 1 do begin
    s := u * (k - 1) + 2;
    t := v * (k - 1) + 2;
    for w := 0 to k - 2 do
      mark(s + (w + (u - 1) * (v - 1)) mod (k - 1), t + w);
    end;
  end;

begin {main}
n := k * k - k + 1;
frame(n, k);
dump
end.
