#include <stdio.h>

#define MAXDIM 200
#define CHARS_PER_LINE 50

static void process();
static int colour();
static void fill_in();
static void output();
static void new_map();
static int get_next();

#define BITMAP 'B'
#define DECOMPOSED 'D'

static char bitmap[MAXDIM][MAXDIM];
static int char_cnt;
static char map_type;
FILE *in_file;


main()
{
    int rows, cols;
    int i, j, tmp;

/*    in_file = fopen("PROBLEME.DAT", "r");
    if (in_file == 0) {
	fprintf(stderr, "Failed to open input file\n");
	exit(1);
    }*/
    in_file = stdin;

    while (1) {
	char map_tmp[2];

	if (fscanf(in_file, "%1s", map_tmp) != 1) {
	    printf("Error reading map type\n");
	    exit(1);
	}

	map_type = map_tmp[0];

	if (map_type == '#') {
	    break;
	}

	if (map_type != BITMAP && map_type != DECOMPOSED) {
	    printf("Illegal map type %c\n", map_type);
	    exit(1);
	}

	if (fscanf(in_file, "%d %d", &rows, &cols) != 2 ||
	    rows <= 0 || rows > MAXDIM || cols <= 0 || cols > MAXDIM) {
	    printf("Illegal bit map dimensions\n");
	    exit(1);
	}

	printf("%c%4d%4d\n", map_type == BITMAP ? DECOMPOSED : BITMAP,
	       rows, cols);
	new_map();
	if (map_type == BITMAP) {
	    for (i = 0; i < rows; i++) {
		for (j = 0; j < cols; j++) {
		    tmp = get_next() - '0';
		    if (tmp < 0 || tmp > 1) {
			fprintf(stderr, "Error on input---%c read\n", tmp);
			exit(1);
		    }
		    bitmap[i][j] = tmp;
		}
	    }
	}
	char_cnt = 0;
	process(0, 0, rows, cols);
	if (map_type == DECOMPOSED) {
	    for (i = 0; i < rows; i++) {
		for (j = 0; j < cols; j++) {
		    output('0' + bitmap[i][j]);
		}
	    }
	}
	putchar('\n');
    }
    return 0;
}


    static void
process(row, col, numrows, numcols)
     int row, col, numrows, numcols;
{
    int rowlen1, rowlen2, collen1, collen2;

    if (numrows == 0 || numcols == 0) {
	return;
    }

    if (map_type == BITMAP) {
	if (colour(row, col, numrows, numcols, 1)) {
	    output('1');
	    return;
	} else if (colour(row, col, numrows, numcols, 0)) {
	    output('0');
	    return;
	} else {
	    output('D');
	}
    } else {
	char next;

	next = get_next();
	if (next == '1') {
	    fill_in(row, col, numrows, numcols, 1);
	    return;
	} else if (next == '0') {
	    fill_in(row, col, numrows, numcols, 0);
	    return;
	} else {
	    if (next != 'D') {
		printf("Illegal character in decomposed bit map: %c\n",
		       next);
		exit(1);
	    }
	}
    }

    rowlen1 = numrows / 2 + numrows % 2;
    rowlen2 = numrows / 2;
    collen1 = numcols / 2 + numcols % 2;
    collen2 = numcols / 2;
    process(row, col, rowlen1, collen1);
    process(row, col+collen1, rowlen1, collen2);
    process(row+rowlen1, col, rowlen2, collen1);
    process(row+rowlen1, col+collen1, rowlen2, collen2);
}


    static int
colour(row, col, numrows, numcols, col_reqd)
    int row, col, numrows, numcols, col_reqd;
{
    int i, j;

    for (i = 0; i < numrows; i++) {
	for (j = 0; j < numcols; j++) {
	    if (bitmap[row+i][col+j] != col_reqd) {
		return 0;
	    }
	}
    }
    return 1;
}


    static void
fill_in(row, col, numrows, numcols, value)
    int row, col, numrows, numcols, value;
{
    int i, j;

    for (i = 0; i < numrows; i++) {
	for (j = 0; j < numcols; j++) {
	    bitmap[row+i][col+j] = value;
	}
    }
}


    static void
output(ch)
    char ch;
{
    if (char_cnt == CHARS_PER_LINE) {
	putchar('\n');
	char_cnt = 0;
    }
    char_cnt++;
    putchar(ch);
}


static int pos;

    static void
new_map()
{
    pos = CHARS_PER_LINE;
}


    static int
get_next()
{
    int ch;

    if (pos == CHARS_PER_LINE) {
	while ((ch = fgetc(in_file)) != '\n' && ch != EOF) {
	    ;
	}
	pos = 0;
    }
    ch = fgetc(in_file);
    if (ch == EOF) {
	fprintf(stderr, "Unexpected error reading input\n");
	exit(1);
    }
    pos++;
    return ch;
}
