#include <stdio.h>
#include <mem.h>
#include <math.h>

typedef struct {
	long num, specimens[2];
} chamber_t;

long         specimens[10];
chamber_t   chambers[5], best_chambers[5];
int         num_chambers, num_specimens, set_num=0;
long         best_imbalance, average;
FILE        *inp, *outp;

long compute_current(void)
{ long imbalance=0;
	int i,j;

	for (i=0; i<num_chambers; i++)
	{ imbalance+= abs( (num_chambers *
	       (chambers[i].specimens[0] + chambers[i].specimens[1])) - average);
	}
	return(imbalance);
}

void read_set(void)
{ int i;

	fscanf(inp, "%d %d", &num_chambers, &num_specimens);
	average = 0;
	for (i=0; i<5; i++)
	{ chambers[i].num=0;
		chambers[i].specimens[0] = 0;
		chambers[i].specimens[1] = 0;
  }
	for (i=0; i<num_specimens; i++)
	{ fscanf(inp, "%d ", &(specimens[i]));
		average += specimens[i];
	}
}

void compute_best(int level)
{ long temp;
	int i,j;

	if (level == num_specimens)
	{ temp = compute_current();
		if (temp < best_imbalance)
		{ best_imbalance = temp;
			memcpy(&best_chambers, &chambers, sizeof(chambers));
		}
	}
	else
  { for (j=0; j<num_chambers; j++)
		{ if (chambers[j].num < 2)
			{	chambers[j].specimens[chambers[j].num] = specimens[level];
				chambers[j].num++;
				compute_best(level+1);
				chambers[j].num--;
				chambers[j].specimens[chambers[j].num] = 0;
      }
		}
	}
}

void print_best(void)
{ int i, j;

	fprintf(outp,"Set #%1d\n", set_num);
	for (i=0; i<num_chambers; i++)
	{ fprintf(outp, "%2d:", i);
		for (j=0; j<best_chambers[i].num; j++)
		{ fprintf(outp, " %1d", best_chambers[i].specimens[j]); }
		fprintf(outp, "\n");
	}
	fprintf(outp, "IMBALANCE %5.5f\n", ( (float) (best_imbalance)) / ( (float) num_chambers) );
  fprintf(outp, "\n");
}

void main(void)
{	int  i, j;

	inp=fopen("balance.in","r");
	outp=fopen("balance.out","w");

	while (!feof(inp))
	{ set_num++;
		best_imbalance=99999;
	  read_set();
		compute_best(0);
		print_best();
	}
 	fclose(inp);
	fclose(outp);
}