program snail;

var
  input_file: text;
  output_file: text;
  well_depth, up, down, fatigue: real;


procedure climb;
var distance: real;
  day: integer;
  delta: real;
begin
  writeln;
  writeln ('Day   Height  Climbed    Up To  Down To');
  writeln ('--- -------- -------- -------- --------');
  delta := up * (fatigue / 100.0);
  distance := 0.0;
  day := 0;
  while true do begin
    day := day + 1;
    write (day:3, distance:9:4, up:9:4);
    distance := distance + up;
    write (distance:9:4);
    up := up - delta;
    if up < 0.0 then up := 0.0;
    if distance > well_depth then begin
      writeln;
      writeln (output_file, 'success on day ', day);
      exit {climb};
    end;
    distance := distance - down;
    writeln (distance:9:4);
    if distance < 0.0 then begin
      writeln (output_file, 'failure on day ', day);
      exit {climb};
    end;
  end;
end;


begin
  assign (input_file, 'snail.in'); reset (input_file);
  assign (output_file, 'snail.out'); rewrite (output_file);
  repeat
    readln (input_file, well_depth, up, down, fatigue);
    if well_depth > 0.0 then climb;
  until well_depth = 0.0;
  close (input_file); close (output_file);
end.

