#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "symtab.h"


SYMTAB_ENTRY SYMTAB[MAX_N_SYMTAB];

int symtab_size = 0;

// Return -1 if not found
int search_symbol(char* name)
{
	int i;

	for (i=0; i<symtab_size; i++) {
		if (0 == strcmp(name, SYMTAB[i].name))
			return i;
	}
	return -1;
}

void insert_symbol(char* name, unsigned int value)
{
	strcpy(SYMTAB[symtab_size].name, name);
	SYMTAB[symtab_size].address = value;
	symtab_size++;
}

/* Uncomment for testing...
main()
{
	int i;

	insert_symbol("CLOOP", 0x1003);
	insert_symbol("COPY", 0x1000);
	insert_symbol("FIRST", 0x1000);
	i = search_symbol("COPY");
	if (i >= 0) printf("address found = %04X\n", SYMTAB[i].address);
	i = search_symbol("ZERO");
	if (i >= 0) printf("address found = %04X\n", SYMTAB[i].address);
}
*/