#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "optab.h"
#include "symtab.h"

#define INPUT_FILENAME "test.sic"

unsigned int LOCCTR=0;
char LABEL[9], OPCODE[9], OPERAND[17];

// Parse an input line and set the global variables LABEL, OPCODE, OPERAND.
// Columns 1-8 are the label field.
// Columns 11-18 are the opcode field.
// COlumns 21-36 are the operand field
void parse(char* s)
{
	char substr[33];
	int i;

	// Intialize
	LABEL[0] = OPCODE[0] = OPERAND[0] = NULL;

	// parse columns 1-8
	strncpy(substr, s, 8);
	substr[8]=NULL;
	sscanf(substr, "%s", LABEL);  // get rid of trailing spaces

	// parse columns 11-18
	strncpy(substr, s+10, 8);
	substr[8]=NULL;
	sscanf(substr, "%s", OPCODE);  // get rid of trailing spaces

	// parse columns 21-36
	strncpy(substr, s+20, 17);
	// Get rid of trailing spaces
	i = strlen(substr)-1;  // strlen-1 to exclude the newline character \n
	if (i>16) i=16;  // max length of OPERAND is 16
	while ((' ' == substr[i-1]) && (i > 0))  // remove trailing spaces
		i--;
	substr[i]=NULL;
	// White spaces may appear in the C'...' string, so we have to scan until 
	// the end of line (or TAB).
	// We assume TAB (\t) cannot appear within the string.
	sscanf(substr, "%[^\t\n]s", OPERAND);

	printf("LABEL=[%s],\tOPCODE=[%s],\tOPERAND=[%s]\n", LABEL, OPCODE, OPERAND);
}

int main()
{
	char s[255];
	FILE *fp;
	int i;

	//
	// *** Pass 1 ***
	//
	fp = fopen(INPUT_FILENAME, "r");
	assert(NULL != fp);

	// read first input line
	fgets(s, 255, fp);
	parse(s);
	if (0==strcmp(OPCODE, "START")) {
		// convert OPERAND to hexidecimal number and store it to LOCCTR
		sscanf(OPERAND, "%x", &LOCCTR);
		fgets(s, 255, fp);
	}
	else {
		LOCCTR = 0;
	}

	while (!feof(fp)) {
		parse(s);
		
		if (NULL != LABEL[0]) {  // there is a symbol in the LABEL field
			i = search_symbol(LABEL);  // search SYMTAB for LABEL


		}

		i = search_optab_by_mnemonic(OPCODE);
		if (i >= 0) {  // an SIC instruction

		}
		else if (0==strcmp(OPCODE, "WORD")) {

		}
		else if (0==strcmp(OPCODE, "RESW")) {

		}
		else if (0==strcmp(OPCODE, "RESB")) {

		}
		else if (0==strcmp(OPCODE, "BYTE")) {

		}

		// read next input line
		fgets(s, 255, fp);
	}
}
