#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "optab.h"


OPTAB_ENTRY OPTAB[MAX_N_OPTAB];

int optab_size = 0;

void load_optab(char* filename)
{
	FILE* fp=fopen(filename, "r");
	int x;
	char s[255];

	assert(NULL != fp);
	while (! feof(fp)) {
		fscanf(fp, "%x %s", &x, s);
		assert((0<=x) && (255 >= x));
		assert(MAX_LEN_MNEMONIC >= strlen(s));

		OPTAB[optab_size].opcode = (unsigned char) x;
		strcpy(OPTAB[optab_size].mnemonic, s);
		optab_size++;
	}
}

// Return -1 if not found
int search_optab_by_opcode(unsigned char opcode)
{
	int i;

	for (i=0; i<optab_size; i++) {
		if (opcode == OPTAB[i].opcode)
			return i;
	}
	return -1;
}

// Return -1 if not found
int search_optab_by_mnemonic(char* mnemonic)
{
	int i;

	for (i=0; i<optab_size; i++) {
		if (0 == strcmp(mnemonic, OPTAB[i].mnemonic))
			return i;
	}
	return -1;
}

/* Uncomment for testing...
main()
{
	unsigned char op = 0x0C;
	load_optab("optab.txt");
	search_optab_by_mnemonic("LDA");
	search_optab_by_opcode(op);
}
*/