function draw_res(res_file)

load(res_file)

figure
hold on
colors = 'gbrmk';
linestyle = {':', '-.', '-', '--', ':'};
marker = {'^', 'o', '*', 'x', 'diamond'};
for i = 1 : 5
    res = sort(precision_table(i, :));
    plot([1:30:length(res)], res(1:30:end), colors(i), 'Marker', marker{i}, 'linestyle', 'none', 'MarkerSize', 8, 'linewidth', 2)
end
xlabel('runs', 'FontSize', 14)
ylabel('accuracy', 'FontSize', 14)
h = legend('ELK', 'SELK', 'SBTCY', 'SSD_{update}', 'BTCY_{update}', 'Location', 'SouthEast');
set(h, 'FontSize', 14);
for i = 1 : 5
    res = sort(precision_table(i, :));
    plot(res, colors(i), 'linewidth', 3, 'linestyle', linestyle{i})
end

figure
hold on
for i = 1 : 5
    timet = sort(time_table(i, :));
    plot([1:30:length(timet)], timet(1:30:end), colors(i), 'Marker', marker{i}, 'linestyle', 'none', 'MarkerSize', 8, 'linewidth', 2)
end
xlabel('runs', 'FontSize', 14)
ylabel('seconds', 'FontSize', 14)
h = legend('ELK', 'SELK', 'SBTCY', 'SSD_{update}', 'BTCY_{update}', 'Location', 'NorthWest');
set(h, 'FontSize', 14);
for i = 1 : 5
    timet = sort(time_table(i, :));
    plot(timet, colors(i), 'linewidth', 3, 'linestyle', linestyle{i})
end
