function [I2, box_centers] = drawBoundingBox(I, support, box_size, n_box, e_wd, clr)

% Input variables:
%
% (1) I: the input image
% (2) support: the support image. The function will draw boxes centered at the
% highest values of the support map
% (3) box_siez: the box size
% (4) n_box: number of boxes to draw on the image
% (5) e_wd: the edge width of the box
% (6) clr: specifies the r, g, b values by [1:255, 1:255, 1:255]

%fig3 = figure;
%set(fig3, 'Name','Support');
%mesh(support);


[dummy, idx] = sort(support(:),'descend');
box_centers = zeros(n_box,2);

T_nrow = box_size(1);
T_ncol = box_size(2);

T_hnrow = floor(T_nrow/2);
T_hncol = floor(T_ncol/2);

I2 = uint8(I);
for i = 1:n_box
    [m,n] = ind2sub(size(I), idx(i));
    box_centers(i,:) = [m,n];
    
    m_s = m-T_hnrow;
    n_s = n-T_hncol;
    try
        for c = 1 : 3
            I2(m_s:m_s+e_wd-1,n_s:n_s+T_ncol-1,c) = clr(c);
            I2(m_s+T_nrow-e_wd:m_s+T_nrow-1,n_s:n_s+T_ncol-1,c) = clr(c);
            I2(m_s:m_s+T_nrow-1,n_s:n_s+e_wd-1,c) = clr(c);
            I2(m_s:m_s+T_nrow-1,n_s+T_ncol-e_wd:n_s+T_ncol-1,c) = clr(c);
        end
    catch me
    end
end