#include <string.h>
#include <math.h>
#include "mex.h"

void mexFunction(int nlhs, mxArray *plhs[ ], 
        int nrhs, const mxArray *prhs[ ]) 
{
    int j, k; 
    int m, n, h, w, nbins;
    double s;
    double *ratio;
    int *hI2;
    double *support;
    double *aux_img;

    if (nrhs != 3) 
        mexErrMsgTxt("The number of input arguments must be three.");
    
    nbins = mxGetM(prhs[0]);
    if (nbins == 1)
        nbins = mxGetN(prhs[0]);
    ratio = mxGetPr(prhs[0]);
    
    /* template size (hI) */
    w = mxGetM(prhs[1]);
    h = mxGetN(prhs[1]);
            
    /* test image size (hI2) */
    m = mxGetM(prhs[2]);
    n = mxGetN(prhs[2]);
    hI2 = (int *) mxGetData(prhs[2]);
    
    /* Create the support map */
    plhs[0] = mxCreateDoubleMatrix(m, n, mxREAL); /* initialized 0 */
    support = mxGetPr(plhs[0]);

    aux_img = (double *) mxCalloc(m*n, sizeof(double));  
    memset(aux_img, 0, m*n*sizeof(double));
    for (j = 0; j < m; j++) {
        for (k = 0; k < n; k++) {
            aux_img[j+k*m] = ratio[hI2[j+k*m]-1];
        }
    }
    for (j =0; j < m; j++) {
        for (k = 1; k < n; k++) {
            aux_img[j + k*m] = aux_img[j + (k-1)*m] + aux_img[j + k*m];
        }                       
    }
    for (j = 1; j < m; j++) {
        for (k = 0; k < n; k++) {
            aux_img[j + k*m] = aux_img[j -1 + k*m] + aux_img[j + k*m];
        }                       
    }
    
    for (j = 10; j < m-w-10; j++) {
        for (k = 10; k < n-h-10; k++) {
            s = aux_img[j + k*m] + aux_img[j+w-1 + (k+h-1)*m]
                    - aux_img[j + (k+h-1)*m]
                    - aux_img[j+w-1 + k*m];
            support[j+(w/2) + (k+h/2)*m] = s/(w*h);
        }                       
    }
    
    mxFree(aux_img);
}         

