clear all
close all

quan = 16; % bin quantization
nbin = ceil(256/quan); % number of bins

num_box = 1;
num_image = 60;
num_runs = 300;

precision_table = zeros(5, num_runs);
recall_table = zeros(5, num_runs);
time_table = zeros(5, num_runs);

load rand_index

for tt =  1 : num_runs

    I_double = double(imresize(imread(['painting/' num2str(rand_index(tt,1), '%03d') '.jpg']), [1000 1000]));
    
    %% read the template image
    I = double(imread(['small_painting/' num2str(rand_index(tt, 2), '%03d') '.jpg']));
    I_double(401:600, 401:600, :) = I;
    
    h = fspecial('gaussian',5,3);
    I = imfilter(I,h);

    
    S2 = zeros(1000,1000);
    S2(401:600, 401:600) = 1;
        
        
    %% compute the bin index of each pixel in the template image
    hI = (nbin^2)*floor(I(:,:,1)/quan) + nbin*floor(I(:,:,2)/quan) + floor(I(:,:,3)/quan) + 1;
    hI = int32(hI); %% hI is an image consisting of the bin indices for the template

    %% compute the histogram for the template image
    p = hist(double(hI(:)), [1:nbin^3]);
    ratio = p./sum(p);

    [I2, support2] = randwarp3(I_double, S2);
    h = fspecial('gaussian',5,3);
    I2 = imfilter(I2,h);

    %% compute the bin index of each pixel in the test image
    hI2 = (nbin^2)*floor(I2(:,:,1)/quan) + nbin*floor(I2(:,:,2)/quan) + floor(I2(:,:,3)/quan) + 1;
    hI2 = int32(hI2); %% hI2 is an image consisting of the bin indices for the test image

    %% the loop for different methods

    % ELK_C
    tstart = tic;
    [support1] = ELK(ratio,hI,hI2);
    time_table(1, tt) = toc(tstart);
    [precision_s, recall_s] = compareBBox3(support1, support2, size(hI), num_box);
    precision_table(1, tt) =  precision_s;
    recall_table(1, tt) =  recall_s;
    
    % SELK_C
    tstart = tic;
    [support1] = SELK(ratio,hI,hI2);
    time_table(2, tt) = toc(tstart);
    [precision_s, recall_s] = compareBBox3(support1, support2, size(hI), num_box);
    precision_table(2, tt) =  precision_s;
    recall_table(2, tt) =  recall_s;
    
    % SBTCY_C
    tstart = tic;
    [support1] = SBTCY(sqrt(ratio),hI,hI2, int32(12));
    time_table(3, tt) = toc(tstart);
    [precision_s, recall_s] = compareBBox3(support1, support2, size(hI), num_box);
    precision_table(3, tt) =  precision_s;
    recall_table(3, tt) =  recall_s;

    % SSD_U
    tstart = tic;
    [support1] = SSD_U(ratio,hI,hI2);
    time_table(4, tt) = toc(tstart);
    [precision_s, recall_s] = compareBBox3(support1, support2, size(hI), num_box);
    precision_table(4, tt) =  precision_s;
    recall_table(4, tt) =  recall_s;

    % BTCY_U
    tstart = tic;
    [support1] = BTCY_U(sqrt(ratio),hI,hI2);
    time_table(5, tt) = toc(tstart);
    [precision_s, recall_s] = compareBBox3(support1, support2, size(hI), num_box);
    precision_table(5, tt) =  precision_s;
    recall_table(5, tt) =  recall_s;
    
    tt
end


save(['res_painting_q' num2str(quan, '%d') '.mat'], 'precision_table', 'recall_table', 'time_table');


