function [precision_s, recall_s] = compareBBox3(support1, support2, box_size, n_box)


[dummy, idx1] = sort(support1(:),'descend');


T_nrow = box_size(1);
T_ncol = box_size(2);

T_hnrow = floor(T_nrow/2);
T_hncol = floor(T_ncol/2);

S1 = zeros(size(support1));
S2 = support2;

for i = 1:n_box
    [m,n] = ind2sub(size(S1), idx1(i));        
    m_s = m-T_hnrow;
    n_s = n-T_hncol;
    try
        S1(m_s:m_s+T_nrow-1,n_s:n_s+T_ncol-1) = 1;
    catch me
    end
end

S1 = (S1>0);
S2 = (S2>0);

recall_s = sum(sum(S1&S2))/sum(sum(S2));

precision_s = sum(sum(S1&S2))/sum(sum(S1));

