#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include "mex.h"

void mexFunction(int nlhs, mxArray *plhs[ ], 
        int nrhs, const mxArray *prhs[ ]) 
{
    int i, j, k, ii, jj, kk; 
    int m, n, h, w, nbins;
    double s;
    double *ratio;
    double *sqrt_table;
    int *ratio_int;
    int *hI2;
    double *support;
    int radr, radc;
    int tmp, npix;
    int nsamp;    
    int *samp;
    int *randlist_r, *randlist_c;
    int factor, *pfactor;
    
    if (nrhs != 3 && nrhs != 4) 
        mexErrMsgTxt("The number of input arguments must be three or four.");
    if (nrhs == 4) {
        pfactor = (int *)mxGetData(prhs[3]);
        factor = *pfactor;
    }
    else
        factor = 12;
       
    nbins = mxGetM(prhs[0]);
    if (nbins == 1)
        nbins = mxGetN(prhs[0]);
    ratio = mxGetPr(prhs[0]);
    ratio_int = (int *) mxCalloc(nbins, sizeof(int));
    for (i = 0; i < nbins; i++) {
        ratio_int[i] = RAND_MAX*ratio[i];
    }
    
    /* template size (hI) */
    w = mxGetM(prhs[1]);
    h = mxGetN(prhs[1]);
    
    sqrt_table = (double *) mxCalloc(h*w+1, sizeof(double));
    for (i = 0; i <= w*h; i++) {
        sqrt_table[i] = sqrt((double)i);        
    }
    
    /* test image size (hI2) */
    m = mxGetM(prhs[2]);
    n = mxGetN(prhs[2]);
    hI2 = (int *) mxGetData(prhs[2]);
    
    
    radr = 0.85*(w/2);
    radc = 0.85*(h/2);
    
    srand(time(NULL));
    
    
    samp = (int *) mxCalloc(m*n, sizeof(int));
    memset(samp, 0, m*n*sizeof(int));
        
    nsamp = 0;
    for (j = radr+1; j < m-radr-1; j++) {
        for (k = radc+1; k < n-radc-1; k++) {
            tmp = ratio_int[hI2[j+k*m]-1];
            if (tmp > 0) {
                if (rand() < tmp) {
                    samp[j+k*m] = 1;
                    nsamp++;
                }
            }
        }
    }        
    
    npix = factor*(m*n)/nsamp;

    randlist_r = (int *)mxCalloc(npix+nsamp, sizeof(int));
    randlist_c = (int *)mxCalloc(npix+nsamp, sizeof(int));
    for (i=0; i<npix+nsamp; i++) {
        randlist_r[i] = rand()%(2*radr+1) - radr;
        randlist_c[i] = rand()%(2*radc+1) - radc;
    }
    
    ii = 0;
    for (j = radr+1; j < m-radr-1; j++) {
        for (k = radc+1; k < n-radc-1; k++) {
            if (samp[j + k*m] > 0) {                
                tmp = 0;
                for (i=0; i<npix; i++) {
                    jj = j + randlist_r[i+ii];
                    kk = k + randlist_c[i+ii];
                    if (hI2[jj+kk*m] == hI2[j+k*m]) {
                        tmp++;
                    }
                }
                ii++;
                if (tmp > 0) {
                    tmp = RAND_MAX/sqrt_table[h*w*tmp/npix];
                    if (tmp < rand()) {
                        samp[j + k*m] = 0;
                    }
                }
                 
            }
        }
    }

    
    /* Create the support map */
    plhs[0] = mxCreateDoubleMatrix(m, n, mxREAL); 
    support = mxGetPr(plhs[0]);

    for (j =0; j < m; j++) {
        for (k = 1; k < n; k++) {
            samp[j + k*m] = samp[j + (k-1)*m] + samp[j + k*m];
        }                       
    }
    for (j = 1; j < m; j++) {
        for (k = 0; k < n; k++) {
            samp[j + k*m] = samp[j -1 + k*m] + samp[j + k*m];
        }                       
    }
    
    for (j = 10; j < m-w-10; j++) {
        for (k = 10; k < n-h-10; k++) {
            s = samp[j + k*m] + samp[j+w-1 + (k+h-1)*m]
                    - samp[j + (k+h-1)*m]
                    - samp[j+w-1 + k*m];
            support[j+(w/2) + (k+h/2)*m] = s/(w*h);
        }                       
    }
    
    
    mxFree(ratio_int);
    mxFree(samp);
    mxFree(sqrt_table);
    mxFree(randlist_r);
    mxFree(randlist_c);

}         

