
clear
clc
load AW.mat;


%% Reading image
inImg1 = im2double(imread(strcat('p5.jpg')));
inImg1 = imresize(inImg1, [80,120]);
[imgH, imgW, imgDim] = size(inImg1);

inImg2 = im2double(imread(strcat('p10.jpg')));
inImg2 = imresize(inImg2, [imgH,imgW]);


%% Building Saliency Saliency
SMap1 = ones(imgH, imgW);
SMap2 = ones(imgH, imgW);

for t = 1 : 15
SMap1(SMap1>0.15) = 1;
SMap2(SMap2>0.15) = 1;
inImgg1 = inImg1.*repmat(SMap1, [1 1 3]);
inImgg2 = inImg2.*repmat(SMap2, [1 1 3]);
[E1, E2] = computeE(inImgg1, inImgg2, W, SMap1, SMap2);
SMap1 = vector2Im(E1, imgH, imgW);
SMap2 = vector2Im(E2, imgH, imgW);
end

%% Visualization
SMap1 = SMap1.^2;
SMap1 = imfilter(SMap1, fspecial('gaussian', [8, 8], 8));
figure(1);
subplot('position', [0 0.5 0.48 0.48])
imshow(SMap1,[]);
subplot('position', [0.5 0.5 0.48 0.48])
imshow(inImg1);

SMap2 = SMap2.^2;
SMap2 = imfilter(SMap2, fspecial('gaussian', [8, 8], 8));
figure(1);
subplot('position', [0 0 0.48 0.48])
imshow(SMap2,[]);
subplot('position', [0.5 0 0.48 0.48])
imshow(inImg2);
