function [E1, E2] = computeE(I1, I2, W, SMap1, SMap2)
%% Vectorization

V1 = im2Vector(I1);
WV1 = W * V1;

V2 = im2Vector(I2);
WV2 = W * V2;

%% IKL
WV1 = abs(WV1).*im2Vector(repmat(SMap1, [1 1 3]));
pdf1 = sum(WV1, 2);
WV2 = abs(WV2).*im2Vector(repmat(SMap2, [1 1 3]));
pdf2 = sum(WV2, 2);

IKL1 = calcIKL(pdf1, pdf2);
IKL2 = calcIKL(pdf2, pdf1);

IKL1 = repmat(IKL1, 1, size(WV1, 2));
EMap1 = IKL1 .* WV1;
E1 = sum(EMap1);

IKL2 = repmat(IKL2, 1, size(WV2, 2));
EMap2 = IKL2 .* WV2;
E2 = sum(EMap2);