function IKL = calcIKL(pdf1, pdf2)

idx = find(pdf1>0 | pdf2>0);
pdf1 = pdf1(idx);
pdf2 = pdf2(idx);

pdf1 = pdf1./sum(pdf1);
pdf2 = pdf2./sum(pdf2);

myeps = 1e-5;

baseKL = sum(pdf1 .* log2(pdf1+myeps) - pdf1 .* log2(pdf2+myeps));
deltaKL = - baseKL + log2(pdf1+myeps) + pdf1 + pdf1.*log2(pdf1+myeps) ...
    - log2(pdf2+myeps) - pdf1.*log2(pdf2+myeps);
deltaKL(deltaKL>0) = 0;
deltaKL = abs(deltaKL);
deltaKL = deltaKL./sum(deltaKL);

IKL = zeros(size(pdf1));
IKL(idx) = deltaKL;
