package cs340100.net.httpserver.threadless;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

import javax.swing.JButton;
import javax.swing.JFrame;

public class TinyHttpServer {
	private ServerSocket server;

	public TinyHttpServer() throws IOException {
		server = new ServerSocket(80);
		System.out.println("Tiny HTTP Server starts...listen to port 80");
	}

	public void startServer() throws IOException {
		makeGUI();
		while (true) {
			Socket client = server.accept();
			processClient(client);
		}
	}

	private void makeGUI() {
		JFrame frame = new JFrame("TinyHttpServer");
		frame.setUndecorated(true);
		Container c = frame.getContentPane();
		JButton closeButton = new JButton("Close!");
		closeButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				release();
				System.exit(0);
			}
		});
		c.add(closeButton);
		frame.setSize(200, 200);
		frame.setLocation(100, 100);
		frame.setVisible(true);
	}

	private void processClient(Socket client) throws IOException {
		InputStream in = client.getInputStream();
		OutputStream out = client.getOutputStream();
		BufferedReader bIn = new BufferedReader(new InputStreamReader(in));
		BufferedOutputStream bOut = new BufferedOutputStream(out);
		bOut.write("HTTP/1.1 200 OK\nServer: YoshiServer\n\n".getBytes());
		String line = "";
		while ((line = bIn.readLine()) != null) {
			// System.out.println(line);
			String[] cmd = line.split(" ");
			if (cmd[0].equalsIgnoreCase("GET")) {
				System.out.println(line); // we skip all other lines except
											// those starting with "GET"
				try {
					FileInputStream toSendFile = new FileInputStream("WWW/"
							+ cmd[1].substring(1));
					BufferedInputStream fileToSend = new BufferedInputStream(
							toSendFile);
					int data = 0;
					while ((data = fileToSend.read()) != -1) {
						bOut.write(data);
					}
					bOut.flush();
				} catch (FileNotFoundException e) {
					FileInputStream toSendFile = new FileInputStream(
							"WWW/sponge.jpg");
					BufferedInputStream fileToSend = new BufferedInputStream(
							toSendFile);
					int data = 0;
					while ((data = fileToSend.read()) != -1) {
						bOut.write(data);
					}
					bOut.flush();
					break;
				}
			}
			break;
		}
		client.close();
	}

	private void release() {
		try {
			server.close();
			System.out.println("Release port 80.");
		} catch (IOException e) {
			// Just close the server and ignore the warnings
		}
	}

	public static void main(String[] args) {
		try {
			TinyHttpServer obj = new TinyHttpServer();
			obj.startServer();
		} catch (IOException e) {
			System.out.println("Socket closed.");
		}
	}

}
