
## Created: 2008-09-29

% plot the function f(x)=x^6-2
a = 0.5:0.01:1.5;
b = sixroot(a);
plot(a,b, 'b', 'linewidth',3, [0.5 1.5],[0 0],'k');

% solve f(x)=0
[x, y] = muller(@sixroot, 0.5, 1.5, 1e-5, 10);

hold on;

% plot the first three points
h1 = plot(x(1:3), y(1:3), 'ko', 'markersize', 15, 'linewidth', 5);
axis([0.5 1.5 -3 11])

% plot the quadratic function
yi = quadratic(x(1:3),y(1:3),a);
h2 = plot(a,yi,'r-', 'linewidth', 3);
pause(15);

% flot the animated history
k = size(x,2);
for i = 2:k-2
  yi = quadratic(x(i:i+2),y(i:i+2),a);
  set(h1, 'xdata', x(i:i+2));
  set(h1, 'ydata', y(i:i+2));
  set(h2, 'ydata', yi); 
  drawnow();
  pause(15);
end   

hold off;
