/*****************************************************************************
*       draw.c
*
*       This is a skeleton polygon drawing program
*
*       Copyright (C) 1990-1991 Apple Computer, Inc.
*       All rights reserved.
*
*       8/27/1991 S. Eric Chen
******************************************************************************/
#include "rad.h"

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#ifdef WIN32
#include <GL/glaux.h>
#else
#include "aux.h"
#endif

/* #define CALLBACK */

void CALLBACK solverLoop(void)
{
  DoRad();
}

void CALLBACK myReshape(GLsizei w, GLsizei h)
{
	glViewport(0,0,w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(60.0, 1.0, 0.1, 600.0);
	gluLookAt(108.0,110.0,403.0,108.0,110.0,0.0,0.0,1.0,0.0);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

void BeginDraw(TView *view, unsigned long color)
{
	glClearColor(0.5,0.5,0.5,1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

void DrawPolygon(int nPts, TPoint3f *pts, TVector3f* n, TColor32b color)
{
  glColor3ub(color.r,color.g,color.b);
	glBegin(GL_POLYGON);
	for(nPts--;nPts>=0;nPts--)
    glVertex3f(pts[nPts].x,pts[nPts].y,pts[nPts].z);
	glEnd();
}

/* Added 4/4/2002 by Chun-Fa Chang */
void DrawShadedPolygon(int nPts, TPoint3f *pts, TVector3f* n, TColor32b* colors)
{
	glBegin(GL_POLYGON);
	for(nPts--;nPts>=0;nPts--) {
	    glColor3ub(colors[nPts].r, colors[nPts].g, colors[nPts].b);
	    glVertex3f(pts[nPts].x,pts[nPts].y,pts[nPts].z);
	}
	glEnd();
}

void EndDraw()
{
	glPopMatrix();
	glFlush();
	auxSwapBuffers();
}

void RunApp(void)
{
	auxInitDisplayMode(AUX_DOUBLE | AUX_RGB | AUX_DEPTH);
	auxInitPosition(150,150,400,400);
	auxInitWindow("Radiosity project");
	glShadeModel(GL_SMOOTH);
  glEnable(GL_DEPTH_TEST);
  glCullFace(GL_BACK);
  glEnable(GL_CULL_FACE);
	auxReshapeFunc(myReshape);
	auxIdleFunc(solverLoop);
	auxMainLoop(NULL);
}


